#version 450 core

layout(std140, binding = 0) uniform ShaderUBO {
    vec2 resolution;
    vec2 loc;
    vec2 size;
};

uniform vec4 color;
uniform float radius;
uniform int lefttop;
uniform int righttop;
uniform int leftbottom;
uniform int rightbottom;
out vec4 FragColor;

float roundBox(vec2 pos, vec2 halfSize, float r) {
    vec2 d = abs(pos) - halfSize + vec2(r);
    return min(max(d.x, d.y), 0.0) + length(max(d, 0.0)) - r;
}

float getMask(vec2 pos, vec2 halfSize) {
    float r = 0.0;
    vec2 fragPos = pos + halfSize;
    if (fragPos.x <= halfSize.x && fragPos.y >= halfSize.y && lefttop == 1)
    r = radius;
    else if (fragPos.x >= halfSize.x && fragPos.y >= halfSize.y && righttop == 1)
    r = radius;
    else if (fragPos.x >= halfSize.x && fragPos.y <= halfSize.y && rightbottom == 1)
    r = radius;
    else if (fragPos.x <= halfSize.x && fragPos.y <= halfSize.y && leftbottom == 1)
    r = radius;
    return roundBox(pos, halfSize, r);
}

void main() {
    vec2 halfSize = size * 0.5;
    vec2 pos = gl_FragCoord.xy - loc - halfSize;
    float mask = getMask(pos, halfSize);
    float distance = fwidth(mask) * 0.5;
    float alpha = smoothstep(distance, -distance, mask);

    if (alpha <= 0.0) {
        discard;
    }

    FragColor = vec4(color.rgb, color.a * alpha);
}