#version 450 core

layout(std140, binding = 0) uniform ShaderUBO {
    vec2 resolution;
    vec2 loc;
    vec2 size;
};

uniform vec4 color;
uniform float radius;
out vec4 FragColor;

float roundBox(vec2 pos, vec2 halfSize, float r) {
    vec2 d = abs(pos) - halfSize + vec2(r);
    return min(max(d.x, d.y), 0.0) + length(max(d, 0.0)) - r;
}

void main() {
    vec2 halfSize = size * 0.5;
    vec2 pos = gl_FragCoord.xy - loc - halfSize;
    float mask = roundBox(pos, halfSize, radius);
    float distance = fwidth(mask) * 0.5;
    float alpha = smoothstep(distance, -distance, mask);

    if (alpha <= 0.0) {
        discard;
    }

    FragColor = vec4(color.rgb, color.a * alpha);
}