#version 450 core

layout(std140, binding = 0) uniform ShaderUBO {
    vec2 resolution;
    vec2 loc;
    vec2 size;
};

uniform vec4 color;
uniform float outlineWidth;
out vec4 FragColor;

void main() {
    vec2 pos = gl_FragCoord.xy;
    vec2 rectMin = loc;
    vec2 rectMax = loc + size;
    float insideRectX = step(rectMin.x, pos.x) * step(pos.x, rectMax.x);
    float insideRectY = step(rectMin.y, pos.y) * step(pos.y, rectMax.y);
    float insideRect = insideRectX * insideRectY;

    if (outlineWidth > 0.0) {
        float distLeft = abs(pos.x - rectMin.x);
        float distRight = abs(pos.x - rectMax.x);
        float distTop = abs(pos.y - rectMin.y);
        float distBottom = abs(pos.y - rectMax.y);
        float minDist = min(min(distLeft, distRight), min(distTop, distBottom));

        if ((minDist < outlineWidth) && (insideRect > 0.0)) {
            FragColor = color;
        } else {
            discard;
        }
    } else {
        if (insideRect > 0.0) {
            FragColor = color;
        } else {
            discard;
        }
    }
}