#version 450 core

layout(std140, binding = 0) uniform ShaderUBO {
    vec2 resolution;
    vec2 loc;
    vec2 size;
};

uniform vec4 color1;
uniform vec4 color2;
uniform float radius;
uniform float time;
out vec4 FragColor;

float smoothNoise(vec2 p) {
    return fract(sin(dot(p, vec2(12.9898, 78.233))) * 43758.5453);
}

float perlinNoise(vec2 p) {
    vec2 i = floor(p);
    vec2 f = fract(p);
    float a = smoothNoise(i);
    float b = smoothNoise(i + vec2(1.0, 0.0));
    float c = smoothNoise(i + vec2(0.0, 1.0));
    float d = smoothNoise(i + vec2(1.0, 1.0));
    vec2 u = f * f * (3.0 - 2.0 * f);
    return mix(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y;
}

float roundBox(vec2 pos, vec2 halfSize, float r) {
    vec2 d = abs(pos) - halfSize + vec2(r);
    return min(max(d.x, d.y), 0.0) + length(max(d, 0.0)) - r;
}

void main() {
    vec2 halfSize = size * 0.5;
    vec2 pos = gl_FragCoord.xy - loc - halfSize;
    vec2 noisePos = (gl_FragCoord.xy - loc) / size;

    float mask = roundBox(pos, halfSize, radius);
    float distance = fwidth(mask) * 0.5;
    float alpha = smoothstep(distance, -distance, mask);

    if (alpha <= 0.0) {
        discard;
    }

    float noise1 = perlinNoise(noisePos * 3.0 + time * 0.3);
    float noise2 = perlinNoise(noisePos * 2.0 - time * 0.2);
    float mixFactor = smoothstep(0.2, 0.8, noise1 * 0.5 + noise2 * 0.5);
    vec4 finalColor = mix(color1, color2, mixFactor);

    FragColor = vec4(finalColor.rgb, finalColor.a * alpha);
}