#version 450 core

layout(std140, binding = 0) uniform ShaderUBO {
    vec2 resolution;
    vec2 loc;
    vec2 size;
};

uniform vec4 color1;
uniform vec4 color2;
uniform float time;
out vec4 FragColor;

float smoothNoise(vec2 p) {
    return fract(sin(dot(p, vec2(12.9898, 78.233))) * 43758.5453);
}

float perlinNoise(vec2 p) {
    vec2 i = floor(p);
    vec2 f = fract(p);
    float a = smoothNoise(i);
    float b = smoothNoise(i + vec2(1.0, 0.0));
    float c = smoothNoise(i + vec2(0.0, 1.0));
    float d = smoothNoise(i + vec2(1.0, 1.0));
    vec2 u = f * f * (3.0 - 2.0 * f);
    return mix(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y;
}

void main() {
    vec2 pos = gl_FragCoord.xy;
    vec2 gradPos = pos - loc;
    if (gradPos.x < 0.0 || gradPos.x > size.x || gradPos.y < 0.0 || gradPos.y > size.y) {
        discard;
    }
    vec2 noisePos = gradPos / size;
    float noise1 = perlinNoise(noisePos * 3.0 + time * 0.3);
    float noise2 = perlinNoise(noisePos * 2.0 - time * 0.2);
    float mixFactor = smoothstep(0.2, 0.8, noise1 * 0.5 + noise2 * 0.5);
    FragColor = mix(color1, color2, mixFactor);
}