#version 450 core

layout(std140, binding = 0) uniform ShaderUBO {
    vec2 resolution;
    vec2 loc;
    vec2 size;
};

uniform vec2 center;
uniform vec4 color;
uniform float radius;
out vec4 FragColor;

float circleSDF(vec2 pos, float r) {
    float d = length(pos) - r;
    float px = fwidth(d);
    return smoothstep(px * 0.5, -px * 0.5, d);
}

void main() {
    vec2 pos = gl_FragCoord.xy;
    float alpha = circleSDF(pos - center, radius);

    if (alpha <= 0.0) {
        discard;
    }
    FragColor = vec4(color.rgb, color.a * alpha);
}