package tech.atani.client.util.system.math;

import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import tech.atani.client.util.Util;

import java.util.concurrent.ThreadLocalRandom;

@SuppressWarnings("unused")
public class MathUtil extends Util {

    public static Double interpolate(double oldValue, double newValue, double interpolationValue){
        return (oldValue + (newValue - oldValue) * interpolationValue);
    }

    public static double lerp(double start, double end, double t) {
        return start + t * (end - start);
    }

    public static float lerp(float start, float end, float t) {
        return start + t * (end - start);
    }

    public static int lerp(int start, int end, float t) {
        return start + Math.round(t * (end - start));
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public static double map(double value, double start1, double end1, double start2, double end2) {
        return start2 + (value - start1) * (end2 - start2) / (end1 - start1);
    }

    public static int range(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public static double range(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(min, max);
    }

    public static float map(float value, float start1, float end1, float start2, float end2) {
        return start2 + (value - start1) * (end2 - start2) / (end1 - start1);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x2 - x1, 2) + Math.pow(y2 - y1, 2));
    }

    public static float distance(float x1, float y1, float x2, float y2) {
        return (float) Math.sqrt(Math.pow(x2 - x1, 2) + Math.pow(y2 - y1, 2));
    }

    public static int distance(int x1, int y1, int x2, int y2) {
        return (int) Math.sqrt(Math.pow(x2 - x1, 2) + Math.pow(y2 - y1, 2));
    }

    public static double round(double value, int places) {
        if (places < 0) places = 0;

        double scale = Math.pow(10, places);
        return Math.round(value * scale) / scale;
    }

    public static float round(float value, int places) {
        if (places < 0) places = 0;

        float scale = (float) Math.pow(10, places);
        return Math.round(value * scale) / scale;
    }

    public static Vec3 closestPointToBox(Vec3 point, AxisAlignedBB box) {
        double x = clamp(point.xCoord, box.minX, box.maxX);
        double y = clamp(point.yCoord, box.minY, box.maxY);
        double z = clamp(point.zCoord, box.minZ, box.maxZ);
        return new Vec3(x, y, z);
    }

    public static float fastInvSqrt(float f) {
        float g = 0.5F * f;
        int i = Float.floatToIntBits(f);
        i = 1597463007 - (i >> 1);
        f = Float.intBitsToFloat(i);
        f *= 1.5F - g * f * f;
        return f;
    }

    public static float fastInvCubeRoot(float f) {
        int i = Float.floatToIntBits(f);
        i = 1419967116 - i / 3;
        float g = Float.intBitsToFloat(i);
        g = 0.6666667F * g + 1.0F / 3.0F * g * g * f;
        g = 0.6666667F * g + 1.0F / 3.0F * g * g * f;
        return g;
    }
}