package tech.atani.client.util.system.files;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import tech.atani.client.util.Util;
import tech.atani.client.util.client.interfaces.IClient;
import tech.atani.client.util.client.interfaces.ILogger;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileUtil extends Util {

    public static Path getRunningPath() {
        final String appdataDirectory = System.getenv("APPDATA");
        File runDir = new File(appdataDirectory != null ? appdataDirectory : System.getProperty("user.home"), ".minecraft/" + IClient.PLAIN_NAME.toLowerCase());

        return runDir.toPath();
    }

    public static void write(Path path, String content) throws IOException {
        Files.writeString(path, content);
    }

    public static String read(Path filePath) throws IOException {
        if (Files.exists(filePath)) {
            return Files.readString(filePath, StandardCharsets.UTF_8);
        } else {
            return "";
        }
    }

    public static void saveJsonToFile(JsonObject json, String fileName) {
        try (FileWriter writer = new FileWriter(FileUtil.getRunningPath() + "/" + fileName)) {
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson(json));
            ILogger.logger.info("Successfully saved {}", fileName);
        } catch (Exception e) {
            ILogger.logger.warn("Failed to save {}", fileName, e);
        }
    }

    public static JsonObject loadFileToJson(String fileName) {
        JsonObject jsonObject = new JsonObject();
        if (Files.exists(Paths.get(FileUtil.getRunningPath().toString(), "/" + fileName))) {
            try {
                jsonObject = JsonParser.parseString(FileUtil.read(Paths.get(FileUtil.getRunningPath().toString(), "/" + fileName))).getAsJsonObject();
                ILogger.logger.info("Successfully loaded {}", fileName);
            } catch (IOException e) {
                jsonObject = new JsonObject();
            }
        }

        return jsonObject;
    }
}
