package tech.atani.client.util.system;

import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import tech.atani.client.util.Util;

import java.util.Random;

public class HWIDUtil extends Util {
    public static final Random random = new Random();

    public static String generateRandomUsername() {
        String[] names = {
                "ShadowX", "Phantom", "PixelFox", "GhostEX", "NovaRun",
                "DarkZed", "LunaX", "IronBat", "Venomix", "Frosty",
                "CyberXR", "BlazeYT", "VoidZX", "Stealth", "ChaosQ",
                "NightX", "ArcaneX", "StormX", "HunterZ", "Thunder",
                "Trixy", "Blade", "Vacuum", "Surprise", "Atom",
                "Omega", "Patriarch", "Paradox", "Limbo", "Particle",
                "IceTruck", "Guru", "Stalker", "Void", "Bliss",
                "Trinity", "Dexter", "Rider", "Daydream", "Cipher",
                "Perplex", "Anon", "Infinity", "Hacker69", "Diddy",
                "Shark", "Aspect", "Swan", "Alien", "Epitome",
                "gRapeMe"
        };
        String baseName = names[random.nextInt(names.length)];
        StringBuilder randomSuffix = new StringBuilder();

        int suffixLength = random.nextInt(3) + 5;
        for (int i = 0; i < suffixLength; i++) {
            if (random.nextBoolean()) {
                randomSuffix.append((char) ('a' + random.nextInt(26)));
            } else {
                randomSuffix.append(random.nextInt(10));
            }
        }

        return baseName + randomSuffix;
    }

    public static String generateRandomUUID() {
        return java.util.UUID.randomUUID().toString().replace("-", "");
    }

    public static String[] stackTraceToArray(String className, StackTraceElement[] stackTraceElements) {
        String[] stackTraceStrings = new String[stackTraceElements.length + 1];

        stackTraceStrings[0] = className;

        for (int i = 0; i < stackTraceElements.length; i++) {
            stackTraceStrings[i + 1] = "\tat " + stackTraceElements[i];
        }

        return stackTraceStrings;
    }

    public static String getComputerName() {
        String computerName = System.getenv("COMPUTERNAME"); // Windows

        if (computerName == null || computerName.isEmpty()) {
            computerName = System.getenv("HOSTNAME"); // Linux/macOS
        }

        if (computerName == null || computerName.isEmpty()) {
            try {
                Process process = Runtime.getRuntime().exec("hostname");
                java.util.Scanner scanner = new java.util.Scanner(process.getInputStream());
                if (scanner.hasNextLine()) {
                    computerName = scanner.nextLine().trim();
                }
                scanner.close();
            } catch (Exception ignored) {}
        }

        return (computerName != null && !computerName.isEmpty()) ? computerName : "Unknown Computer";
    }

    public static int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static String getCPU() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            if (osName.contains("11")) {
                return getWindows11ProcessorName();
            } else {
                return getWindows10ProcessorName();
            }
        } else {
            SystemInfo systemInfo = new SystemInfo();
            CentralProcessor processor = systemInfo.getHardware().getProcessor();
            return processor.getProcessorIdentifier().getName();
        }
    }

    private static String getWindows11ProcessorName() {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"powershell", "-Command",
                    "Get-CimInstance Win32_Processor | Select-Object -ExpandProperty Name"});
            java.util.Scanner scanner = new java.util.Scanner(process.getInputStream());
            StringBuilder result = new StringBuilder();
            while (scanner.hasNextLine()) {
                result.append(scanner.nextLine().trim());
            }
            scanner.close();
            return !result.isEmpty() ? result.toString() : "Unknown Processor";
        } catch (Exception e) {
            return "Unknown Processor";
        }
    }

    private static String getWindows10ProcessorName() {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "wmic cpu get Name"});
            java.util.Scanner scanner = new java.util.Scanner(process.getInputStream());
            scanner.nextLine();
            String name = scanner.nextLine().trim();
            scanner.close();
            return name;
        } catch (Exception e) {
            return "Unknown Processor";
        }
    }
    public static String getGPU() {
        if (!Display.isCreated()) {
            return "No Display Created";
        }

        if (GLFW.glfwGetCurrentContext() == 0) {
            return "No OpenGL Context";
        }

        try {
            String gpu = GL11.glGetString(GL11.GL_RENDERER);
            String vendor = GL11.glGetString(GL11.GL_VENDOR);

            if (gpu == null || gpu.trim().isEmpty()) {
                return "Unknown GPU";
            }

            return vendor != null ? vendor + " " + gpu : gpu;
        } catch (Exception e) {
            return "GPU Detection Failed: " + e.getMessage();
        }
    }

    public static String getMaxRAM() {
        long i = Runtime.getRuntime().maxMemory();
        long j = Runtime.getRuntime().totalMemory();
        long k = Runtime.getRuntime().freeMemory();
        long l = j - k;

        return formatSize(l) + " / " + formatSize(i);
    }

    public static String formatSize(long bytes) {
        long mb = bytes / (1024 * 1024);
        return mb + " MB";
    }
}