package tech.atani.client.util.game.render.shader.impl.shape;

import net.minecraft.client.gui.ScaledResolution;
import tech.atani.client.util.game.render.shader.data.ShaderData;
import tech.atani.client.util.game.render.shader.data.base.Base;
import java.awt.Color;

@ShaderData(frag = "Circle.fsh")
public class CircleShader extends Base<CircleShader.Params> {
    @Override
    public void render(Params params) {
        base(params.x() - params.radius(), params.y() - params.radius(), params.radius() * 2, params.radius() * 2,
                new Color[] { new Color(params.intColor(), true) },
                null, () -> {
                    int scale = new ScaledResolution(mc).getScaleFactor();
                    float centerX = params.x() * scale;
                    float centerY = (mc.displayHeight - params.y() * scale);
                    setUniformFloats("center", centerX, centerY);
                    setUniformFloats("radius", params.radius() * scale);
                });
    }

    public record Params(float x, float y, float radius, int intColor) {}
}