package tech.atani.client.util.game.render.shader.impl.noise;

import net.minecraft.client.gui.ScaledResolution;
import tech.atani.client.util.game.render.shader.data.ShaderData;
import tech.atani.client.util.game.render.shader.data.base.Base;
import java.awt.Color;

@ShaderData(frag = "NoiseRound.fsh")
@SuppressWarnings("unused")
public class NoiseRoundRect extends Base<NoiseRoundRect.Params> {
    private float time = 0;
    private long lastFrameTime = System.nanoTime();

    @Override
    public void render(Params params) {
        long currentTime = System.nanoTime();
        float deltaTime = (currentTime - lastFrameTime) / 1_000_000_000.0f;
        lastFrameTime = currentTime;
        time += params.timeValue() * deltaTime * 30;

        base(params.x(), params.y(), params.width(), params.height(),
                new Color[] { new Color(params.color1Int(), true), new Color(params.color2Int(), true) },
                null, () -> {
                    setUniformFloats("radius", params.radius() * new ScaledResolution(mc).getScaleFactor());
                    float[] color1 = getCachedUniformFloats("colors[0]");
                    float[] color2 = getCachedUniformFloats("colors[1]");
                    setUniformFloats("color1", color1[0], color1[1], color1[2], color1[3]);
                    setUniformFloats("color2", color2[0], color2[1], color2[2], color2[3]);
                    setUniformFloats("time", time);
                });
    }

    public record Params(float x, float y, float width, float height, float radius, int color1Int, int color2Int, float timeValue) {}
}