package tech.atani.client.util.game.render.shader.impl;

import net.minecraft.client.gui.ScaledResolution;
import tech.atani.client.util.game.render.shader.data.ShaderData;
import tech.atani.client.util.game.render.shader.data.base.Base;
import java.awt.Color;

@ShaderData(frag = "SelectiveRoundedRectShader.fsh")
public class SelectiveRoundedRectShader extends Base<SelectiveRoundedRectShader.Params> {

    @Override
    public void render(Params params) {
        base(params.x(), params.y(), params.width(), params.height(),
                new Color[] { new Color(params.intColor(), true) }, null, () -> {
                    setUniformFloats("radius", params.radius() * new ScaledResolution(mc).getScaleFactor());
                    setUniformInts("lefttop", params.lefttop() ? 1 : 0);
                    setUniformInts("righttop", params.righttop() ? 1 : 0);
                    setUniformInts("leftbottom", params.leftbottom() ? 1 : 0);
                    setUniformInts("rightbottom", params.rightbottom() ? 1 : 0);
                });
    }

    public record Params(float x, float y, float width, float height, float radius, int intColor, boolean lefttop, boolean righttop, boolean leftbottom, boolean rightbottom) {}
}