package tech.atani.client.util.game.render.shader.impl;

import net.minecraft.client.gui.ScaledResolution;
import tech.atani.client.util.game.render.shader.data.ShaderData;
import tech.atani.client.util.game.render.shader.data.base.Base;
import java.awt.Color;

@ShaderData(frag = "RoundedRectShader.fsh")
public class RoundedRectShader extends Base<RoundedRectShader.Params> {

    @Override
    public void render(Params params) {
        base(params.x(), params.y(), params.width(), params.height(),
                new Color[] { new Color(params.intColor(), true) }, null, () -> setUniformFloats("radius", params.radius() * new ScaledResolution(mc).getScaleFactor()));
    }

    public record Params(float x, float y, float width, float height, float radius, int intColor) {}
}