package tech.atani.client.util.game.render.shader.impl;

import net.minecraft.client.gui.ScaledResolution;
import tech.atani.client.util.game.render.shader.data.ShaderData;
import tech.atani.client.util.game.render.shader.data.base.Base;
import java.awt.Color;

@ShaderData(frag = "RectangleShader.fsh")
public class RectShader extends Base<RectShader.Params> {

    @Override
    public void render(Params params) {
        base(params.x(), params.y(), params.width(), params.height(),
                new Color[] { new Color(params.intColor(), true) }, null, () -> setUniformFloats("outlineWidth", params.outlineWidth() * new ScaledResolution(mc).getScaleFactor()));
    }

    public record Params(float x, float y, float width, float height, int intColor, float outlineWidth) {}
}