package tech.atani.client.util.game.render.shader.impl;

import net.minecraft.client.gui.ScaledResolution;
import tech.atani.client.util.game.render.shader.data.ShaderData;
import tech.atani.client.util.game.render.shader.data.base.Base;
import java.awt.Color;

@ShaderData(frag = "GradientRoundedRectShader.fsh")
public class GradientRoundedRectShader extends Base<GradientRoundedRectShader.Params> {

    @Override
    public void render(Params params) {
        base(params.x(), params.y(), params.width(), params.height(),
                params.colors(), null, () -> {
                    setUniformFloats("radius", params.radius() * new ScaledResolution(mc).getScaleFactor());
                    setUniformFloats("angle", params.angle());
                    setUniformInts("interpolationType", params.interpolationType());
                    setUniformFloats("outlineWidth", params.outlineWidth() * new ScaledResolution(mc).getScaleFactor());
                });
    }

    public record Params(float x, float y, float width, float height, float radius, Color[] colors, float angle, int interpolationType, float outlineWidth) {}
}