package tech.atani.client.util.game.render.shader.data.renderer;

import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import tech.atani.client.Atani;
import tech.atani.client.util.Util;
import tech.atani.client.util.game.render.shader.impl.*;
import tech.atani.client.util.game.render.shader.impl.noise.NoiseRect;
import tech.atani.client.util.game.render.shader.impl.shape.CircleShader;
import java.awt.Color;

public class Renderer extends Util {
    public static void drawRectangle(float x, float y, float width, float height, int color) {
        Atani.instance.shaderStorage.getT(RectShader.class)
                .render(new RectShader.Params(x, y, width, height, color, 0f));
    }

    public static void drawRectangle(float x, float y, float width, float height, Color color) {
        drawRectangle(x, y, width, height, color.getRGB());
    }

    public static void drawRectangle(float x, float y, float width, float height, Color color, float outlineWidth) {
        Atani.instance.shaderStorage.getT(RectShader.class)
                .render(new RectShader.Params(x, y, width, height, color.getRGB(), outlineWidth));
    }

    public static void drawNoiseRectangle(double x, double y, double width, double height, int color1, int color2, float time) {
        Atani.instance.shaderStorage.getT(NoiseRect.class)
                .render(new NoiseRect.Params((float)x, (float)y, (float)width, (float)height, color1, color2, time));
    }

    public static void drawNoiseRectangle(double x, double y, double width, double height, Color color1, Color color2, float time) {
        drawNoiseRectangle(x, y, width, height, color1.getRGB(), color2.getRGB(), time);
    }

    public static void drawRoundedRect(float x, float y, float width, float height, float radius, int color) {
        Atani.instance.shaderStorage.getT(RoundedRectShader.class)
                .render(new RoundedRectShader.Params(x, y, width, height, radius, color));
    }

    public static void drawRoundedRect(float x, float y, float width, float height, float radius, Color color) {
        drawRoundedRect(x, y, width, height, radius, color.getRGB());
    }

    public static void drawRoundedGradientRectangle(float x, float y, float width, float height, float radius, Color[] colors, float angle, int interpolationType) {
        Atani.instance.shaderStorage.getT(GradientRoundedRectShader.class)
                .render(new GradientRoundedRectShader.Params(x, y, width, height, radius, colors, angle, interpolationType, 0f));
    }

    public static void drawRoundedGradientRectangle(float x, float y, float width, float height, float radius, Color[] colors, float angle, int interpolationType, float outlineWidth) {
        Atani.instance.shaderStorage.getT(GradientRoundedRectShader.class)
                .render(new GradientRoundedRectShader.Params(x, y, width, height, radius, colors, angle, interpolationType, outlineWidth));
    }

    public static void drawRoundedSelectiveRectangle(float x, float y, float width, float height, float radius, int color, boolean leftTop, boolean rightTop, boolean leftBottom, boolean rightBottom) {
        Atani.instance.shaderStorage.getT(SelectiveRoundedRectShader.class)
                .render(new SelectiveRoundedRectShader.Params(x, y, width, height, radius, color, leftTop, rightTop, leftBottom, rightBottom));
    }

    public static void drawRoundedSelectiveRectangle(float x, float y, float width, float height, float radius, Color color, boolean leftTop, boolean rightTop, boolean leftBottom, boolean rightBottom) {
        drawRoundedSelectiveRectangle(x, y, width, height, radius, color.getRGB(), leftTop, rightTop, leftBottom, rightBottom);
    }

    public static void drawCircle(float x, float y, float radius, int color) {
        Atani.instance.shaderStorage.getT(CircleShader.class)
                .render(new CircleShader.Params(x, y, radius, color));
    }

    public static void drawCircle(float x, float y, float radius, Color color) {
        drawCircle(x, y, radius, color.getRGB());
    }

    public static void drawGradientRectangle(float x, float y, float width, float height, Color[] colors, float angle, int interpolationType) {
        Atani.instance.shaderStorage.getT(GradientRectShader.class)
                .render(new GradientRectShader.Params(x, y, width, height, colors, angle, interpolationType, 0f));
    }

    public static void drawGradientRectangle(float x, float y, float width, float height, Color[] colors, float angle, int interpolationType, float outlineWidth) {
        Atani.instance.shaderStorage.getT(GradientRectShader.class)
                .render(new GradientRectShader.Params(x, y, width, height, colors, angle, interpolationType, outlineWidth));
    }

    public static void drawHead(EntityLivingBase entity, double x, double y, int size, Color color) {
        if (!(entity instanceof EntityPlayer)) return;
        GlStateManager.pushMatrix();
        mc.getTextureManager().bindTexture(((AbstractClientPlayer)entity).getLocationSkin());
        GlStateManager.color(color.getRed() / 255f, color.getGreen() / 255f, color.getBlue() / 255f, color.getAlpha() / 255f);
        Gui.drawScaledCustomSizeModalRect((int)x, (int)y, 8, 8, 8, 8, size, size, 64, 64);
        GlStateManager.popMatrix();
    }
}