package tech.atani.client.util.game.render.shader.data.framebuffer;

@SuppressWarnings("unused")
public interface FrameBuffer {
    int handle();
    void viewport();
    void beginWrite();
    void beginReadColorAttachment();
    void beginReadDepthAttachment();
    void endRead();
    void endWrite();
    void clear(boolean depth);
    void setClearColor(float r, float g, float b, float a);
    void setFilter(FilterMode filter);
    void setWrap(TextureWrap wrap);
    void resize(int width, int height);
    void resizeIfNeeded(int width, int height);
    void free();
    void copyDepth(FrameBuffer frameBuffer);
    int width();
    int height();
    int colorAttachment();
    int depthAttachment();
}

