package tech.atani.client.util.game.render.shader.data.base;

import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import tech.atani.client.util.client.interfaces.ILogger;
import tech.atani.client.util.game.render.shader.Shader;
import java.awt.Color;

public abstract class Base<T> extends Shader {
    protected void base(float x, float y, float width, float height, Color[] colors, float[] quadParams, Runnable uniformSetup) {
        ScaledResolution sr = new ScaledResolution(mc);

        int scale = sr.getScaleFactor();
        float scaledX = x * scale;
        float scaledY = (mc.displayHeight - (height * scale)) - (y * scale);
        float scaledWidth = width * scale;
        float scaledHeight = height * scale;

        float[] mvpMatrix = createOrthographicMatrix((float) mc.displayWidth / scale, (float) mc.displayHeight / scale);

        GlStateManager.enableAlpha();
        setBlend(true);
        bind();

        if (currentlyBoundProgram == 0) {
            unbind();
            setBlend(false);
            GlStateManager.disableAlpha();
            return;
        }

        updateUBO(new float[]{(float)mc.displayWidth, (float)mc.displayHeight},
                new float[]{scaledX, scaledY},
                new float[]{scaledWidth, scaledHeight});

        setUniformMatrix4fv(mvpMatrix);

        if (colors != null && colors.length > 0) {
            if (colors.length == 1) {
                Color color = colors[0];
                setUniformFloats("color", color.getRed() / 255F, color.getGreen() / 255F, color.getBlue() / 255F, color.getAlpha() / 255F);
            } else {
                int colorCount = Math.min(colors.length, 5);
                if (colors.length > 5) {
                    ILogger.logger.warn("Only first 5 colors used, {} provided", colors.length);
                }
                setUniformInts("colorCount", colorCount);
                for (int i = 0; i < colorCount; i++) {
                    Color color = colors[i];
                    setUniformFloats("colors[" + i + "]", color.getRed() / 255F, color.getGreen() / 255F, color.getBlue() / 255F, color.getAlpha() / 255F);
                }
            }
        }

        if (uniformSetup != null) {
            uniformSetup.run();
        }

        if (quadParams != null && quadParams.length == 4) {
            drawQuad(quadParams[0], quadParams[1], quadParams[2], quadParams[3]);
        } else {
            drawQuad(x, y, width, height);
        }

        unbind();
        setBlend(false);
        GlStateManager.disableAlpha();
    }

    public abstract void render(T params);
}