package tech.atani.client.util.game.render.font.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class StreamUtils {
    public static final int BUFFER_SIZE = 8192;

    public static String readStreamAsUtf8(InputStream input) throws IOException {
        return new String(readStream(input), StandardCharsets.UTF_8);
    }

    public static byte[] readStream(InputStream input) throws IOException {
        Objects.requireNonNull(input, "input must not be null");

        try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
            byte[] buf = new byte[BUFFER_SIZE];
            int count;
            while ((count = input.read(buf)) != -1) {
                out.write(buf, 0, count);
            }
            return out.toByteArray();
        }
    }
}