package tech.atani.client.util.game.render.font.resource.impl;

import tech.atani.client.util.game.render.font.resource.ResourceManager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassPathResourceManager extends ResourceManager {
    private final String basePath;

    public ClassPathResourceManager(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public List<String> list(String directory) throws IOException {
        List<String> files = new ArrayList<>();
        URL dirUrl = getClass().getResource(basePath + directory);
        if (dirUrl == null) return files;

        if (dirUrl.getProtocol().equals("file")) {
            File dir = new File(dirUrl.getPath());
            if (dir.exists() && dir.isDirectory()) {
                for (File file : Objects.requireNonNull(dir.listFiles())) {
                    files.add(file.getName());
                }
            }
        } else if (dirUrl.getProtocol().equals("jar")) {
            String jarPath = dirUrl.getPath().substring(5, dirUrl.getPath().indexOf("!"));
            try (JarFile jarFile = new JarFile(URLDecoder.decode(jarPath, StandardCharsets.UTF_8))) {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String entry = entries.nextElement().getName();
                    if (entry.startsWith(basePath.substring(1) + directory) && !entry.equals(basePath.substring(1) + directory + "/")) {
                        files.add(entry.substring(entry.lastIndexOf("/") + 1));
                    }
                }
            }
        }

        return files;
    }

    @Override
    public InputStream getInputStream(String path) throws FileNotFoundException {
        InputStream stream = getClass().getResourceAsStream(basePath + path);

        if (stream == null) {
            throw new FileNotFoundException("Resource not found: " + path);
        }
        return stream;
    }
}