package tech.atani.client.util.game.render.font.resource;

import java.io.*;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public abstract class ResourceManager {
    private static final int BUFFER_SIZE = 8192;

    public abstract InputStream getInputStream(String path) throws FileNotFoundException;

    public BufferedReader getBufferedReader(String path, Charset charset) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader(getInputStream(path), charset));
    }

    public BufferedReader getBufferedReader(String path) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader(getInputStream(path), StandardCharsets.UTF_8));
    }

    public byte[] readAsByteArray(String path) throws IOException {
        try (InputStream stream = getInputStream(path)) {
            return readStream(stream);
        }
    }

    public String readAsString(String path, Charset charset) throws IOException {
        return new String(readAsByteArray(path), charset);
    }

    public String readAsString(String path) throws IOException {
        return readAsString(path, StandardCharsets.UTF_8);
    }

    private static byte[] readStream(InputStream stream) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
            byte[] buf = new byte[BUFFER_SIZE];
            int count;
            while ((count = stream.read(buf)) != -1) {
                out.write(buf, 0, count);
            }
            return out.toByteArray();
        }
    }

    public abstract List<String> list(String directory) throws IOException;
}