package tech.atani.client.util.game.render.font.gui.shader.vao;

import tech.atani.client.util.game.render.font.gui.shader.ShaderProgram;

import static org.lwjgl.opengl.GL20.*;

public class VertexAttribute {
    private final int index;
    private final int size;
    private final int type;
    private final boolean normalized;
    private final int stride;
    private final long offset;

    public VertexAttribute(int index, int size, int type, boolean normalized, int stride, long offset) {
        this.index = index;
        this.size = size;
        this.type = type;
        this.normalized = normalized;
        this.stride = stride;
        this.offset = offset;
    }

    public VertexAttribute(int program, String name, int size, int type, boolean normalized, int stride, long offset) {
        this(glGetAttribLocation(program, name), size, type, normalized, stride, offset);
    }

    public VertexAttribute(ShaderProgram program, String name, int size, int type, boolean normalized, int stride, long offset) {
        this(program.getName(), name, size, type, normalized, stride, offset);
    }

    public void setVertexAttribPointer() {
        glVertexAttribPointer(index, size, type, normalized, stride, offset);
    }

    public void enableVertexAttribArray() {
        glEnableVertexAttribArray(index);
    }

    public void disableVertexAttribArray() {
        glDisableVertexAttribArray(index);
    }

    public int getIndex() {
        return index;
    }

    public int getSize() {
        return size;
    }

    public int getType() {
        return type;
    }

    public boolean isNormalized() {
        return normalized;
    }

    public int getStride() {
        return stride;
    }

    public long getOffset() {
        return offset;
    }
}
