package tech.atani.client.util.game.render.font.gui.shader.vao;

import tech.atani.client.util.game.render.font.gui.shader.bo.BufferObject;

import java.util.List;

import static org.lwjgl.opengl.GL30.*;

public class VertexArrayObject {
    protected final int name;

    public VertexArrayObject() {
        name = glGenVertexArrays();
    }

    public void setAttributes(BufferObject vbo, BufferObject ebo, List<VertexAttribute> attributes) {
        bind();

        if (ebo != null) {
            ebo.bind();
        }
        vbo.bind();
        for (VertexAttribute attrib : attributes) {
            attrib.setVertexAttribPointer();
            attrib.enableVertexAttribArray();
        }

        unbind();
        vbo.unbind();
        if (ebo != null) {
            ebo.unbind();
        }
    }

    public void bind() {
        glBindVertexArray(name);
    }

    public void unbind() {
        glBindVertexArray(0);
    }

    public void delete() {
        glDeleteVertexArrays(name);
    }

    public int getName() {
        return name;
    }
}
