package tech.atani.client.util.game.render.font.gui.shader.texture;

import net.minecraft.client.renderer.GlStateManager;

import java.nio.*;

import static org.lwjgl.opengl.GL11.*;

public class Texture2d {
    private final int target;
    private final int level;
    private final int internalFormat;
    private int width;
    private int height;
    private final int format;
    private final int type;

    private final int name;

    public Texture2d(int target, int level, int internalFormat, int format, int type) {
        this.target = target;
        this.level = level;
        this.internalFormat = internalFormat;
        this.format = format;
        this.type = type;

        name = glGenTextures();
    }

    public void texParameteri(int pname, int param) {
        glTexParameteri(target, pname, param);
    }

    public void texImage2d(int width, int height, ByteBuffer pixels) {
        this.width = width;
        this.height = height;
        glTexImage2D(target, level, internalFormat, width, height, 0, format, type, pixels);
    }

    public void texImage2d(int width, int height, DoubleBuffer pixels) {
        this.width = width;
        this.height = height;
        glTexImage2D(target, level, internalFormat, width, height, 0, format, type, pixels);
    }

    public void texImage2d(int width, int height, FloatBuffer pixels) {
        this.width = width;
        this.height = height;
        glTexImage2D(target, level, internalFormat, width, height, 0, format, type, pixels);
    }

    public void texImage2d(int width, int height, IntBuffer pixels) {
        this.width = width;
        this.height = height;
        glTexImage2D(target, level, internalFormat, width, height, 0, format, type, pixels);
    }

    public void texImage2D(int width, int height, ShortBuffer pixels) {
        this.width = width;
        this.height = height;
        glTexImage2D(target, level, internalFormat, width, height, 0, format, type, pixels);
    }

    public void texImage2D(int width, int height, long pixelsBufferOffset) {
        this.width = width;
        this.height = height;
        glTexImage2D(target, level, internalFormat, width, height, 0, format, type, pixelsBufferOffset);
    }

    public void bind() {
        if (target == GL_TEXTURE_2D) {
            GlStateManager.bindTexture(name);
        } else {
            glBindTexture(target, name);
        }
    }

    public void unbind() {
        if (target == GL_TEXTURE_2D) {
            GlStateManager.bindTexture(0);
        } else {
            glBindTexture(target, 0);
        }
    }

    public int getTarget() {
        return target;
    }

    public int getLevel() {
        return level;
    }

    public int getInternalFormat() {
        return internalFormat;
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    public int getFormat() {
        return format;
    }

    public int getType() {
        return type;
    }

    public int getName() {
        return name;
    }
}
