package tech.atani.client.util.game.render.font.gui.shader.bo;

import java.nio.*;

import static org.lwjgl.opengl.GL15.*;

public class BufferObject {
    protected final int target;
    protected long size;
    protected int usage;

    protected final int name;

    public BufferObject(int target) {
        this.target = target;

        name = glGenBuffers();
    }

    public void bind() {
        glBindBuffer(target, name);
    }

    public void unbind() {
        glBindBuffer(target, 0);
    }

    public void delete() {
        glDeleteBuffers(name);
    }

    public void bufferData(long size, int usage) {
        this.size = size;
        this.usage = usage;
        glBufferData(target, size, usage);
    }

    public void bufferData(ByteBuffer data, int usage) {
        this.size = data.remaining();
        this.usage = usage;
        glBufferData(target, data, usage);
    }

    public void bufferData(DoubleBuffer data, int usage) {
        this.size = data.remaining();
        this.usage = usage;
        glBufferData(target, data, usage);
    }

    public void bufferData(FloatBuffer data, int usage) {
        this.size = data.remaining();
        this.usage = usage;
        glBufferData(target, data, usage);
    }

    public void bufferData(IntBuffer data, int usage) {
        this.size = data.remaining();
        this.usage = usage;
        glBufferData(target, data, usage);
    }

    public void bufferData(ShortBuffer data, int usage) {
        this.size = data.remaining();
        this.usage = usage;
        glBufferData(target, data, usage);
    }

    public void bufferSubData(int offset, ByteBuffer data) {
        glBufferSubData(target, offset, data);
    }

    public void bufferSubData(int offset, DoubleBuffer data) {
        glBufferSubData(target, offset, data);
    }

    public void bufferSubData(int offset, FloatBuffer data) {
        glBufferSubData(target, offset, data);
    }

    public void bufferSubData(int offset, IntBuffer data) {
        glBufferSubData(target, offset, data);
    }

    public void bufferSubData(int offset, ShortBuffer data) {
        glBufferSubData(target, offset, data);
    }

    public int getName() {
        return name;
    }

    public int getUsage() {
        return usage;
    }

    public long getSize() {
        return size;
    }
}
