package tech.atani.client.util.game.render.font.gui.shader;

import tech.atani.client.util.game.render.font.utils.StreamUtils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

import static org.lwjgl.opengl.GL20.*;

public class Shader {
    private final int name;

    public Shader(String source, int type) {
        name = glCreateShader(type);
        glShaderSource(name, source);
        glCompileShader(name);

        if (glGetShaderi(name, GL_COMPILE_STATUS) == 0) {
            int logLength = glGetShaderi(name, GL_INFO_LOG_LENGTH);
            throw new IllegalStateException("Failed to compile shader: " + glGetShaderInfoLog(name, logLength));
        }
    }

    public Shader(InputStream in, int type) throws IOException {
        this(new String(StreamUtils.readStream(in), StandardCharsets.UTF_8), type);
    }

    public void attach(int program) {
        glAttachShader(program, name);
    }

    public void detach(int program) {
        glDetachShader(program, name);
    }

    public void delete() {
        glDeleteShader(name);
    }

    public int getName() {
        return name;
    }
}
