package tech.atani.client.util.game.render.font.gui.font.renderer.shader.line;

import tech.atani.client.util.game.render.font.gui.shader.Shader;
import tech.atani.client.util.game.render.font.gui.shader.ShaderProgram;

import java.nio.FloatBuffer;

import static org.lwjgl.opengl.GL11.GL_TRIANGLES;
import static org.lwjgl.opengl.GL11.glDrawArrays;
import static org.lwjgl.opengl.GL20.GL_FRAGMENT_SHADER;
import static org.lwjgl.opengl.GL20.GL_VERTEX_SHADER;

public class LineShaderProgram extends ShaderProgram {
    private int lineCount;

    public LineShaderProgram(FloatBuffer modelView, FloatBuffer projection,
                             String fragShaderSource, String vertShaderSource) {
        super(modelView, projection, new Shader(fragShaderSource, GL_FRAGMENT_SHADER), new Shader(vertShaderSource, GL_VERTEX_SHADER));
    }

    @Override
    public void use() {
        updateMatrices = true;
        super.use();
    }

    @Override
    public void drawArrays() {
        glDrawArrays(GL_TRIANGLES, 0, 6 * lineCount);
    }

    public void setLineCount(int count) {
        this.lineCount = count;
    }
}
