package tech.atani.client.util.game.render.font.gui.font.renderer.element;

import tech.atani.client.storage.impl.FontStorage;
import tech.atani.client.util.game.render.font.gui.font.ScaledFont;
import tech.atani.client.util.game.render.font.gui.font.formatting.FormattingProcessor;
import tech.atani.client.util.game.render.font.gui.font.renderer.ChunkedRenderer;
import tech.atani.client.util.game.render.font.gui.font.renderer.shader.line.LineBuffer;
import tech.atani.client.util.game.render.font.gui.font.renderer.shader.line.LineShaderProgram;
import tech.atani.client.util.game.render.font.gui.font.renderer.shader.sdf.SdfShaderProgram;
import tech.atani.client.util.game.render.font.gui.font.renderer.shader.sdf.SdfTextBuffer;

import java.util.Objects;

public class Label {
    private final FormattingProcessor processor;

    private final SdfShaderProgram sdfProgram;
    private final LineShaderProgram lineProgram;

    private final SdfTextBuffer textBuffer;
    private final LineBuffer lineBuffer;

    private ScaledFont font;
    private ChunkedRenderer renderer;

    private int usage;

    private String text;

    private int bufferSize;

    private float x;
    private float y;
    private float z;

    private int color;

    public Label(FontStorage fontStorage, FormattingProcessor processor) {
        this.processor = processor;

        sdfProgram = new SdfShaderProgram(fontStorage.getSdfFragShaderSource(), fontStorage.getSdfVertShaderSource());
        lineProgram = new LineShaderProgram(
                sdfProgram.getModelView(), sdfProgram.getProjection(),
                fontStorage.getLineFragShaderSource(), fontStorage.getLineVertShaderSource()
        );

        textBuffer = new SdfTextBuffer(sdfProgram);
        lineBuffer = new LineBuffer(lineProgram);
    }

    public void draw() {
        renderer.begin();
        renderer.render();
        renderer.end();
    }

    public FormattingProcessor getProcessor() {
        return processor;
    }

    public ScaledFont getFont() {
        return font;
    }

    public String getText() {
        return text;
    }

    public float getX() {
        return x;
    }

    public float getY() {
        return y;
    }

    public float getZ() {
        return z;
    }

    public int getColor() {
        return color;
    }

    public int getUsage() {
        return usage;
    }

    public void set(ScaledFont font, String text, float x, float y, float z, int color, int usage) {
        if (Objects.equals(this.font, font) && Objects.equals(this.text, text) && this.x == x && this.y == y && this.z == z && this.color == color && this.usage == usage) {
            return;
        }

        boolean resizeBuffers = this.usage != usage;
        if (!Objects.equals(text, this.text)) {
            int newTextLength = processor.getTextLength(text);
            if (bufferSize < newTextLength) {
                resizeBuffers = true;
                bufferSize = newTextLength;
            }
        }

        boolean updateSdfTexture = this.font == null || !Objects.equals(font.getAtlas(), this.font.getAtlas());

        this.font = font;
        this.text = text;
        this.x = x;
        this.y = y;
        this.z = z;
        this.color = color;
        this.usage = usage;

        if (updateSdfTexture) {
            sdfProgram.setTextureData(font.getAtlas());
        }
        updateRenderer(resizeBuffers);
    }

    public void setFont(ScaledFont font) {
        set(font, text, x, y, z, color, usage);
    }

    public void setText(String text) {
        set(font, text, x, y, z, color, usage);
    }

    public void setPosition(float x, float y, float z) {
        set(font, text, x, y, z, color, usage);
    }

    public void setColor(int color) {
        set(font, text, x, y, z, color, usage);
    }

    private void updateRenderer(boolean resizeBuffers) {
        if (resizeBuffers) {
            textBuffer.resize(bufferSize, usage);
            lineBuffer.resize(bufferSize, usage);
        }

        renderer = new ChunkedRenderer(font, processor.chars(text, color, false), textBuffer, lineBuffer, x, y, z);
        renderer.upload();
    }
}
