package tech.atani.client.util.game.render.font.gui.font.formatting.impl;

import tech.atani.client.util.game.render.font.gui.font.ScaledFont;
import tech.atani.client.util.game.render.font.gui.font.formatting.FormattingProcessor;
import tech.atani.client.util.game.render.font.gui.font.formatting.style.StyledCharacter;
import tech.atani.client.util.game.render.font.gui.font.formatting.style.TextStyle;

import java.util.ArrayList;
import java.util.List;

public class NoFormattingProcessor implements FormattingProcessor {
    @Override
    public List<StyledCharacter> chars(String text, int defaultColor, boolean shadow) {
        List<StyledCharacter> chars = new ArrayList<>();

        if ((defaultColor & 0xFC000000) == 0) {
            defaultColor = defaultColor | 0xFF000000;
        }

        if (shadow) {
            defaultColor = (defaultColor & 0x00FCFCFC) / 4 | (defaultColor & 0xFF000000);
        }

        TextStyle style = new TextStyle(defaultColor, false, false, false);
        for (int i = 0; i < text.length(); i++) {
            chars.add(new StyledCharacter(text.charAt(i), style));
        }
        return chars;
    }

    @Override
    public int getTextLength(String text) {
        return text.length();
    }

    @Override
    public String getUnformattedText(String text) {
        return text;
    }

    @Override
    public float getStringWidth(ScaledFont font, String text) {
        if (font.getSize() == 0) {
            return 0;
        }

        float currentWidth = 0;
        for (int i = 0; i < text.length(); i++) {
            currentWidth += font.getCharWidth(text.charAt(i));
        }
        return currentWidth;
    }

    @Override
    public String trimStringToWidth(ScaledFont font, String text, int width, boolean reverse) {
        StringBuilder builder = new StringBuilder();
        float currentWidth = 0;
        int start = reverse ? text.length() - 1 : 0;
        int direction = reverse ? -1 : 1;

        for (int i = start; i >= 0 && i < text.length() && currentWidth < width; i += direction) {
            char ch = text.charAt(i);
            float charWidth = font.getCharWidth(ch);
            currentWidth += charWidth;

            if (currentWidth > width) {
                break;
            }

            if (reverse) {
                builder.insert(0, ch);
            } else {
                builder.append(ch);
            }
        }

        return builder.toString();
    }

    public String getFormatFromString(String text) {
        return "";
    }

    @Override
    public int sizeStringToWidth(ScaledFont font, String text, float wrapWidth) {
        float x = 0;
        int index = 0;
        int spaceIndex = -1;

        for (; index < text.length(); index++) {
            char ch = text.charAt(index);

            switch (ch) {
                case '\n':
                    return index;

                case ' ':
                    spaceIndex = index;

                default:
                    x += font.getCharWidth(ch);
                    break;
            }

            if (x > wrapWidth) {
                break;
            }
        }

        if (spaceIndex != -1 && index != text.length() /* ignore space if we already reached the end */) {
            return spaceIndex;
        }
        return index;
    }
}
