package tech.atani.client.util.game.render.font.gui.font.formatting.impl;

import tech.atani.client.util.game.render.font.gui.font.ScaledFont;
import tech.atani.client.util.game.render.font.gui.font.formatting.FormattingProcessor;
import tech.atani.client.util.game.render.font.gui.font.formatting.style.StyledCharacter;
import tech.atani.client.util.game.render.font.gui.font.formatting.style.TextStyle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;

import java.util.ArrayList;
import java.util.List;

public class MinecraftFormattingProcessor implements FormattingProcessor {
    private static final int[] colorCodes = new int[32];

    static {
        GameSettings settings = Minecraft.getMinecraft().gameSettings;
        for (int i = 0; i < 32; i++) {
            int j = ((i / 8) % 2) * 85;

            int r = ((i / 4) % 2) * 170 + j;
            int g = ((i / 2) % 2) * 170 + j;
            int b = (i       % 2) * 170 + j;

            if (i == 6 /* EnumChatFormatting.GOLD */) {
                r += 85;
            }

            // no one uses anaglyph so this could be removed
            if (settings.anaglyph) {
                int r1 = (r * 30 + g * 59 + b * 11) / 100;
                int g1 = (r * 30 + g * 70) / 100;
                int b1 = (r * 30 + b * 70) / 100;
                r = r1;
                g = g1;
                b = b1;
            }

            // darker colors for text shadows
            if (i >= 16) {
                r /= 4;
                g /= 4;
                b /= 4;
            }

            colorCodes[i] = (r & 255) << 16 | (g & 255) << 8 | b & 255;
        }
    }

    @Override
    public List<StyledCharacter> chars(String text, int defaultColor, boolean shadow) {
        List<StyledCharacter> chars = new ArrayList<>();

        if ((defaultColor & 0xFC000000) == 0) {
            defaultColor = defaultColor | 0xFF000000;
        }

        if (shadow) {
            defaultColor = (defaultColor & 0x00FCFCFC) / 4 | (defaultColor & 0xFF000000);
        }

        TextStyle style = new TextStyle(defaultColor, false, false, false);
        byte alpha = (byte) (defaultColor >> 24);

        for (int i = 0; i < text.length(); i++) {
            char ch = text.charAt(i);
            if (ch == '§' && i + 1 < text.length()) {
                int l = "0123456789abcdefklmnor".indexOf(Character.toLowerCase(text.charAt(i + 1)));

                if (l < 16 /* 0 - f */) {
                    if (l < 0) {
                        l = 15;
                    }

                    if (shadow) {
                        l += 16;
                    }

                    style = new TextStyle((colorCodes[l] & 0x00FFFFFF) | (alpha << 24), false, false, false);
                } else if (l == 16 /* k */) {
                    style = new TextStyle(style.getColor(), true, style.isUnderline(), style.isStrikethrough());
                } else if (l == 17) {
                } else if (l == 18 /* m */) {
                    style = new TextStyle(style.getColor(), style.isRandom(), style.isUnderline(), true);
                } else if (l == 19 /* n */) {
                    style = new TextStyle(style.getColor(), style.isRandom(), true, style.isStrikethrough());
                } else if (l == 20) {
                } else /* r */ {
                    style = new TextStyle(defaultColor, false, false, false);
                }

                i++;
                continue;
            }

            chars.add(new StyledCharacter(ch, style));
        }

        return chars;
    }

    @Override
    public int getTextLength(String text) {
        int length = 0;
        for (int i = 0; i < text.length(); i++) {
            char ch = text.charAt(i);
            if (ch == '§' && i + 1 < text.length()) {
                i++;
                continue;
            }
            length++;
        }
        return length;
    }

    @Override
    public String getUnformattedText(String text) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); i++) {
            char ch = text.charAt(i);
            if (ch == '§' && i + 1 < text.length()) {
                i++;
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    @Override
    public float getStringWidth(ScaledFont font, String text) {
        if (font.getSize() == 0) {
            return 0;
        }

        float currentWidth = 0;
        for (int i = 0; i < text.length(); i++) {
            char ch = text.charAt(i);
            if (ch == '§' && i + 1 < text.length()) {
                i++;
                continue;
            }
            currentWidth += font.getCharWidth(ch);
        }
        return currentWidth;
    }

    @Override
    public String trimStringToWidth(ScaledFont font, String text, int width, boolean reverse) {
        StringBuilder builder = new StringBuilder();
        float currentWidth = 0;
        int start = reverse ? text.length() - 1 : 0;
        int direction = reverse ? -1 : 1;
        boolean formatting = false;

        for (int i = start; i >= 0 && i < text.length() && currentWidth < width; i += direction) {
            char ch = text.charAt(i);
            float charWidth = font.getCharWidth(ch);

            if (formatting) {
                formatting = false;
            } else if (ch == '§') {
                formatting = true;
            } else {
                currentWidth += charWidth;
            }

            if (currentWidth > width) {
                break;
            }

            if (reverse) {
                builder.insert(0, ch);
            } else {
                builder.append(ch);
            }
        }

        return builder.toString();
    }

    public String getFormatFromString(String text) {
        StringBuilder builder = new StringBuilder();
        int i = -1;
        int length = text.length();

        while ((i = text.indexOf('§', i + 1)) != -1 && i < length - 1) {
            char ch = text.charAt(i + 1);

            if (isFormatColor(ch)) {
                builder.setLength(0);
                builder.append("§").append(ch);
            } else if (isFormatSpecial(ch)) {
                builder.append("§").append(ch);
            }
        }

        return builder.toString();
    }

    @Override
    public int sizeStringToWidth(ScaledFont font, String text, float wrapWidth) {
        float x = 0;
        int index = 0;
        int spaceIndex = -1;

        for (; index < text.length(); index++) {
            char ch = text.charAt(index);

            switch (ch) {
                case '\n':
                    return index;

                case ' ':
                    spaceIndex = index;

                default:
                    x += font.getCharWidth(ch);
                    break;

                case '§':
                    if (index < text.length() - 1) {
                        index++;
                    }
            }

            if (x > wrapWidth) {
                break;
            }
        }

        if (spaceIndex != -1 && index != text.length() /* ignore space if we already reached the end */) {
            return spaceIndex;
        }
        return index;
    }

    public int getColorCode(char ch) {
        int i = "0123456789abcdef".indexOf(ch);
        if (i >= 0) {
            return colorCodes[i];
        }

        return 0x00FFFFFF;
    }

    private boolean isFormatColor(char ch) {
        return ch >= '0' && ch <= '9'
                || ch >= 'a' && ch <= 'f'
                || ch >= 'A' && ch <= 'F';
    }

    private boolean isFormatSpecial(char ch) {
        return ch >= 'k' && ch <= 'o'
                || ch >= 'K' && ch <= 'O'
                || ch == 'r' || ch == 'R';
    }
}
