package tech.atani.client.util.game.render.font.gui.font.formatting;

import tech.atani.client.util.game.render.font.gui.font.ScaledFont;
import tech.atani.client.util.game.render.font.gui.font.formatting.impl.MinecraftFormattingProcessor;
import tech.atani.client.util.game.render.font.gui.font.formatting.style.StyledCharacter;

import java.util.List;

public interface FormattingProcessor {
    List<StyledCharacter> chars(String v, int defaultColor, boolean shadow);
    int getTextLength(String text);
    String getUnformattedText(String text);
    String getFormatFromString(String text);
    int sizeStringToWidth(ScaledFont font, String str, float wrapWidth);

    float getStringWidth(ScaledFont font, String text);
    String trimStringToWidth(ScaledFont font, String text, int width, boolean reverse);

    default String trimStringToWidth(ScaledFont font, String text, int width) {
        return trimStringToWidth(font, text, width, false);
    }

    static FormattingProcessor createDefault() {
        return new MinecraftFormattingProcessor();
    }
}
