package tech.atani.client.util.game.render.font.gui.font;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import tech.atani.client.storage.impl.FontStorage;
import tech.atani.client.util.game.render.font.gui.font.glyph.SdfAtlas;
import tech.atani.client.util.game.render.font.gui.font.renderer.shader.line.LineBuffer;
import tech.atani.client.util.game.render.font.gui.font.renderer.shader.line.LineShaderProgram;
import tech.atani.client.util.game.render.font.gui.font.renderer.shader.sdf.SdfShaderProgram;
import tech.atani.client.util.game.render.font.gui.font.renderer.shader.sdf.SdfTextBuffer;

import java.io.IOException;
import java.nio.file.Path;

import static org.lwjgl.opengl.GL15.GL_DYNAMIC_DRAW;

public class Font {
    public static final float WEIGHT_REGULAR = 400;

    private static final int CHAR_BUFFER_SIZE = 128;

    private final FontStorage fontStorage;

    private final String name;
    private final SdfAtlas atlas;

    private SdfTextBuffer textBuffer;
    private LineBuffer lineBuffer;

    public Font(FontStorage fontStorage, String name, SdfAtlas atlas) {
        this.fontStorage = fontStorage;
        this.name = name;
        this.atlas = atlas;
    }

    public ScaledFont newScaledFont(float size, float weight) {
        return new ScaledFont(this, size, weight);
    }

    public SdfTextBuffer getTextBuffer() {
        if (textBuffer == null || lineBuffer == null) {
            SdfShaderProgram sdfProgram = new SdfShaderProgram(fontStorage.getSdfFragShaderSource(), fontStorage.getSdfVertShaderSource());
            LineShaderProgram lineProgram = new LineShaderProgram(
                    sdfProgram.getModelView(), sdfProgram.getProjection(),
                    fontStorage.getLineFragShaderSource(), fontStorage.getLineVertShaderSource()
            );

            sdfProgram.setTextureData(atlas);

            SdfTextBuffer textBuffer = new SdfTextBuffer(sdfProgram);
            LineBuffer lineBuffer = new LineBuffer(lineProgram);

            textBuffer.resize(CHAR_BUFFER_SIZE, GL_DYNAMIC_DRAW);
            lineBuffer.resize(CHAR_BUFFER_SIZE, GL_DYNAMIC_DRAW);

            this.textBuffer = textBuffer;
            this.lineBuffer = lineBuffer;
        }

        return textBuffer;
    }

    public LineBuffer getLineBuffer() {
        getTextBuffer();
        return lineBuffer;
    }

    public String getName() {
        return name;
    }

    public SdfAtlas getAtlas() {
        return atlas;
    }

    public void write(JsonWriter writer, Path atlasesDirectory) throws IOException {
        writer.beginObject();

        writer.name("name").value(name);

        writer.name("atlas");
        atlas.write(writer, atlasesDirectory);

        writer.endObject();
    }

    public static Font read(FontStorage fontStorage, JsonReader reader, Path atlasesDirectory) throws IOException {
        reader.beginObject();

        String name = null;
        SdfAtlas atlas = null;
        while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "name":
                    name = reader.nextString();
                    break;
                case "atlas":
                    atlas = SdfAtlas.read(reader, atlasesDirectory);
                    break;
                default:
                    reader.skipValue();
            }
        }

        reader.endObject();
        return new Font(fontStorage, name, atlas);
    }
}
