package tech.atani.client.util.game.render.animation;

/**
 * An enum that contains all code that actually does math to keep the actual rendering code cleaner
 * Also this kinda proves that I have no idea of how to name stuff properly
 *
 * @author Marie
 */
public enum EnumTransition {
    @Deprecated LINEAR((current, target, progress) -> current + (target - current) * progress), // looks shit, mostly just to show how things work
    SQRT((current, target, progress) -> current + (target - current) * (float) Math.sqrt(progress)),
    EASE_IN_OUT((current, target, progress) -> {
        float t = Math.min(1, progress);
        t = t * t * (3 - 2 * t);
        return current + (target - current) * t;
    }),
    BOUNCE((current, target, progress) -> {
        float t = Math.min(1, progress);
        if (t < 1 / 2.75f) {
            return current + (target - current) * (7.5625f * t * t);
        } else if (t < 2 / 2.75f) {
            t -= 1.5f / 2.75f;
            return current + (target - current) * (7.5625f * t * t + 0.75f);
        } else if (t < 2.5f / 2.75f) {
            t -= 2.25f / 2.75f;
            return current + (target - current) * (7.5625f * t * t + 0.9375f);
        } else {
            t -= 2.625f / 2.75f;
            return current + (target - current) * (7.5625f * t * t + 0.984375f);
        }
    });

    private final TransitionFunction transitionFunction;

    EnumTransition(TransitionFunction transitionFunction) {
        this.transitionFunction = transitionFunction;
    }

    public float apply(float current, float target, float progress) {
        return transitionFunction.apply(current, target, progress);
    }
}