package tech.atani.client.util.game.render.animation;

import lombok.Getter;

/**
 * Holy shit this took me way longer than i'd like to admit
 *
 * @author Marie
 */
public class Animation {
    private final float transitionSpeed;
    private final EnumTransition transitionType;
    @Getter
    private float value;
    private long lastUpdateTime;

    public Animation(float initialValue, EnumTransition transitionType, float transitionSpeed) {
        this.value = initialValue;
        this.transitionType = transitionType;
        this.transitionSpeed = transitionSpeed;
        this.lastUpdateTime = System.nanoTime();
    }

    public Animation(float initialValue, float transitionSpeed) {
        this(initialValue, EnumTransition.SQRT, transitionSpeed);
    }

    public void update(float target) {
        long currentTime = System.nanoTime();
        float deltaTime = (currentTime - lastUpdateTime) / 1000000000f; // this is the right value. source: allah
        lastUpdateTime = currentTime;

        float progress = transitionSpeed * deltaTime;
        value = transitionType.apply(value, target, progress);
    }
}