package tech.atani.client.util.game.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;
import tech.atani.client.util.Util;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;

public class Utility extends Util {
    public static void startScissor() {
        GL11.glPushMatrix();
        GL11.glEnable(GL11.GL_SCISSOR_TEST);
    }

    public static void drawScissor(double x, double y, double width, double height) {
        width = Math.max(width, 0.1);

        ScaledResolution sr = new ScaledResolution(Minecraft.getMinecraft());
        double scale = sr.getScaleFactor();

        y = sr.getScaledHeight() - y;

        x *= scale;
        y *= scale;
        width *= scale;
        height *= scale;

        GL11.glScissor((int) x, (int) (y - height), (int) width, (int) height);
    }

    public static void endScissor() {
        GL11.glDisable(GL11.GL_SCISSOR_TEST);
        GL11.glPopMatrix();
    }

    public static boolean isHover(float mouseX, float mouseY, float x, float y, float width, float height) {
        return mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }

    public static void drawVerticalGradient(float x, float y, float width, float height, int startColor, int endColor) {
        float alphaStart = (float) (startColor >> 24 & 255) / 255.0F;
        float redStart = (float) (startColor >> 16 & 255) / 255.0F;
        float greenStart = (float) (startColor >> 8 & 255) / 255.0F;
        float blueStart = (float) (startColor & 255) / 255.0F;
        float alphaEnd = (float) (endColor >> 24 & 255) / 255.0F;
        float redEnd = (float) (endColor >> 16 & 255) / 255.0F;
        float greenEnd = (float) (endColor >> 8 & 255) / 255.0F;
        float blueEnd = (float) (endColor & 255) / 255.0F;

        int steps = 100;
        for (int i = 0; i < steps; i++) {
            float ratio = (float) i / (float) steps;
            int alpha = (int) (alphaStart + (alphaEnd - alphaStart) * ratio);
            int red = (int) (redStart + (redEnd - redStart) * ratio);
            int green = (int) (greenStart + (greenEnd - greenStart) * ratio);
            int blue = (int) (blueStart + (blueEnd - blueStart) * ratio);
            int color = (alpha << 24) | (red << 16) | (green << 8) | blue;

            float rectHeight = height / steps;
            Renderer.drawRectangle(x, y + i * rectHeight, width, rectHeight, color);
        }
    }

    /**
     *  Returns the steve's head 512x512 png encoded in base64
     * @return A base64 encoded file string
     */
    public static String getSteveHead() {
        return "iVBORw0KGgoAAAANSUhEUgAAASwAAAEsCAIAAAD2HxkiAAAE1UlEQVR4nOzVu4rdZRuH4XcyazL58uGmylgIsbdQ+5BS3JTaWwS08BBEW0WxsRHEytIgFlqkSpFaC1uFuCGoKUIgRMMks2ZkWnufu7muE/it/wv3ejbPPfPYGnR0PLl2arNzZnLucHs0OXf6pEfbybkzZ0bfc621t9mdnDs5mVw7Nf2gwL+IEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCG2OTquf8J/7Ohk9Av/f+7s5Nxa64mzO5Nz27U7ObfWunP/cHJue7KdnHMJoSdCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIIbYZ3vvo7TeGF/f3zk7O/e/c45Nza60Hf90b3dud/uO+++fvk3MffH1tcs4lhJ4IISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGI7X7775uTe+f39ybm11t+Hh5Nzu7vTH3j33t3JuYsHFybn1lq//vLj8OIwlxBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBim/P7+5N7r77zyeTcWuu1yx9Ozl25fHNybq118eDC5Nyn3x5Mzq21vrrx8eTc1ffempxzCaEnQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoTYzudXXpzcO3jq6cm5tdZm/8nJuW+uX5+cm/f6S5eGF2/99tPk3M3bdybnXELoiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIbe4/2k7uPbx1c3JurXX1xneTcy8/+8Lk3Lz3P/tiePGVS89Pzu2svck5lxB6IoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIbX7+4/bk3vHx8eTcvGs/fD+8uLu3GV4cdv/BdnLu8NHDyTmXEHoihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGIihJgIISZCiIkQYiKEmAghJkKIiRBiIoSYCCEmQoiJEGL/BAAA//+J4VhDvV4pYgAAAABJRU5ErkJggg==";
    }
}
