package tech.atani.client.util.game.player.waveycapes.simulation;

import tech.atani.client.Atani;
import tech.atani.client.module.impl.client.Cape;
import tech.atani.client.util.game.player.waveycapes.math.CloneableVector2f;
import tech.atani.client.util.game.player.waveycapes.math.Point;
import tech.atani.client.util.game.player.waveycapes.math.Stick;

import java.util.ArrayList;
import java.util.List;

public class StickSimulation {

    public List<Point> points = new ArrayList<>();
    public List<Stick> sticks = new ArrayList<>();
    public float gravity = 20f;
    public int numIterations = 30;

    public void simulate() {
        gravity = Atani.instance.moduleStorage.getT(Cape.class).gravity.intValue();
        float maxBend = Atani.instance.moduleStorage.getT(Cape.class).maxBend.intValue();

        float deltaTime = 50f / 1000f; // fixed timescale
        CloneableVector2f down = new CloneableVector2f(0, gravity * deltaTime);
        CloneableVector2f tmp = new CloneableVector2f(0, 0);
        for (Point p : points) {
            if (!p.locked) {
                tmp.copy(p.position);
                // p.position.add(p.position).subtract(p.prevPosition);
                p.position.subtract(down);
                p.prevPosition.copy(tmp);
            }
        }

        // prevent the cape from clipping into the player
        Point basePoint = points.getFirst();
        for (Point p : points) {
            if (p != basePoint && p.position.x - basePoint.position.x > 0) {
                p.position.x = basePoint.position.x - 0.1f;
            }
        }

        // Doesn't work like it should at all, but it prevents some folding into itself, so it stays for now
        for (int i = points.size() - 2; i >= 1; i--) {
            double angle = getAngle(points.get(i).position, points.get(i - 1).position, points.get(i + 1).position);
            angle *= 57.2958;
            if (angle > 360) {
                angle -= 360;
            }
            if (angle < -360) {
                angle += 360;
            }
            double abs = Math.abs(angle);
            if (abs < 180 - maxBend) {
                points.get(i + 1).position = getReplacement(points.get(i).position, points.get(i - 1).position, angle,
                        180 - maxBend + 1);
            }
            if (abs > 180 + maxBend) {
                points.get(i + 1).position = getReplacement(points.get(i).position, points.get(i - 1).position, angle,
                        180 + maxBend - 1);
            }
        }

        // move into correct direction
        for (int i = 0; i < numIterations; i++) {
            for (int x = sticks.size() - 1; x >= 0; x--) {
                Stick stick = sticks.get(x);
                CloneableVector2f stickCentre = stick.pointA.position.clone().add(stick.pointB.position).div(2);
                CloneableVector2f stickDir = stick.pointA.position.clone().subtract(stick.pointB.position).normalize();
                if (!stick.pointA.locked) {
                    stick.pointA.position = stickCentre.clone().add(stickDir.clone().mul(stick.length / 2));
                }
                if (!stick.pointB.locked) {
                    stick.pointB.position = stickCentre.clone().subtract(stickDir.clone().mul(stick.length / 2));
                }
            }
        }

        // fix in the position/length, this prevents it from acting like a spring/stretchy
        for (Stick stick : sticks) {
            CloneableVector2f stickDir = stick.pointA.position.clone().subtract(stick.pointB.position).normalize();
            if (!stick.pointB.locked) {
                stick.pointB.position = stick.pointA.position.clone().subtract(stickDir.mul(stick.length));
            }
        }
    }

    private CloneableVector2f getReplacement(CloneableVector2f middle, CloneableVector2f prev, double angle, double target) {
        double theta = target / 57.2958;
        float x = prev.x - middle.x;
        float y = prev.y - middle.y;
        if (angle < 0) {
            theta *= -1;
        }
        double cs = Math.cos(theta);
        double sn = Math.sin(theta);
        return new CloneableVector2f((float) ((x * cs) - (y * sn) + middle.x), (float) ((x * sn) + (y * cs) + middle.y));
    }

    private double getAngle(CloneableVector2f middle, CloneableVector2f prev, CloneableVector2f next) {
        return Math.atan2(next.y - middle.y, next.x - middle.x) - Math.atan2(prev.y - middle.y, prev.x - middle.x);
    }
}