package tech.atani.client.util.game.player.waveycapes.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.util.MathHelper;
import tech.atani.client.Atani;
import tech.atani.client.module.impl.client.Cape;
import tech.atani.client.util.game.player.RotationUtil;
import tech.atani.client.util.system.math.MathUtil;

public class CustomCapeRenderLayer implements LayerRenderer<AbstractClientPlayer> {

    static final int partCount = 16;
    private ModelRenderer[] customCape = new ModelRenderer[partCount];
    private final RenderPlayer playerRenderer;
    private SmoothCapeRenderer smoothCapeRenderer = new SmoothCapeRenderer();

    public CustomCapeRenderLayer(RenderPlayer playerRenderer, ModelBase model) {
        this.playerRenderer = playerRenderer;
        buildMesh(model);
    }

    private void buildMesh(ModelBase model) {
        customCape = new ModelRenderer[partCount];
        for (int i = 0; i < partCount; i++) {
            ModelRenderer base = new ModelRenderer(model, 0, i);
            base.setTextureSize(64, 32);
            this.customCape[i] = base.addBox(-5.0F, (float) i, -1.0F, 10, 1, 1);
        }
    }

    @Override
    public void doRenderLayer(AbstractClientPlayer abstractClientPlayer, float paramFloat1, float paramFloat2, float deltaTick,
                              float animationTick, float paramFloat5, float paramFloat6, float paramFloat7) {
        if (abstractClientPlayer.isInvisible()) return;

        if (!abstractClientPlayer.hasPlayerInfo() || abstractClientPlayer.isInvisible()
                || !abstractClientPlayer.isWearing(EnumPlayerModelParts.CAPE)
                || abstractClientPlayer.getLocationCape() == null) {
            return;
        }

        this.playerRenderer.bindTexture(abstractClientPlayer.getLocationCape());

        if (Atani.instance.moduleStorage.getT(Cape.class).capeStyle.is("Smooth")) {
            smoothCapeRenderer.renderSmoothCape(this, abstractClientPlayer, deltaTick);
        } else {
            ModelRenderer[] parts = customCape;
            for (int part = 0; part < partCount; part++) {
                ModelRenderer model = parts[part];
                GlStateManager.pushMatrix();
                modifyPoseStack(abstractClientPlayer, deltaTick, part);
                model.render(0.0625F);
                GlStateManager.popMatrix();
            }
        }
    }

    private void modifyPoseStack(AbstractClientPlayer abstractClientPlayer, float h, int part) {
        modifyPoseStackVanilla(abstractClientPlayer, h, part);
    }

    void modifyPoseStackVanilla(AbstractClientPlayer abstractClientPlayer, float h, int part) {
        GlStateManager.translate(0.0D, 0.0D, 0.125D);

        double d = MathUtil.lerp(abstractClientPlayer.prevChasingPosX, abstractClientPlayer.chasingPosX, h)
                - MathUtil.lerp(abstractClientPlayer.prevPosX, abstractClientPlayer.posX, h);

        double e = MathUtil.lerp(abstractClientPlayer.prevChasingPosY, abstractClientPlayer.chasingPosY, h)
                - MathUtil.lerp(abstractClientPlayer.prevPosY, abstractClientPlayer.posY, h);

        double m = MathUtil.lerp(abstractClientPlayer.prevChasingPosZ, abstractClientPlayer.chasingPosZ, h)
                - MathUtil.lerp(abstractClientPlayer.prevPosZ, abstractClientPlayer.posZ, h);

        float n = abstractClientPlayer.prevRenderYawOffset + abstractClientPlayer.renderYawOffset - abstractClientPlayer.prevRenderYawOffset;
        if (abstractClientPlayer == Minecraft.getMinecraft().thePlayer) {
            n = RotationUtil.getLastYaw() + RotationUtil.getYaw() - RotationUtil.getLastYaw();
        }
        double o = Math.sin(n * 0.017453292F);
        double p = -Math.cos(n * 0.017453292F);
        float height = (float) e * 10.0F;
        height = MathHelper.clamp_float(height, -6.0F, 32.0F);
        float swing = (float) (d * o + m * p) * easeOutSine(1.0F / partCount * part) * 100;
        swing = MathHelper.clamp_float(swing, 0.0F, 150.0F * easeOutSine(1F / partCount * part));
        float sidewaysRotationOffset = (float) (d * p - m * o) * 100.0F;
        sidewaysRotationOffset = MathHelper.clamp_float(sidewaysRotationOffset, -20.0F, 20.0F);
        float t = MathUtil.lerp(abstractClientPlayer.prevCameraYaw, abstractClientPlayer.cameraYaw, h);
        height += (float) (Math.sin(MathUtil.lerp(abstractClientPlayer.prevDistanceWalkedModified, abstractClientPlayer.distanceWalkedModified, h) * 6.0F) * 32.0F * t);
        if (abstractClientPlayer.isSneaking()) {
            height += 25.0F;
            GlStateManager.translate(0, 0.15F, 0);
        }

        float naturalWindSwing = getNaturalWindSwing(part);

        GlStateManager.rotate(6.0F + swing / 2.0F + height + naturalWindSwing, 1.0F, 0.0F, 0.0F);
        GlStateManager.rotate(sidewaysRotationOffset / 2.0F, 0.0F, 0.0F, 1.0F);
        GlStateManager.rotate(-sidewaysRotationOffset / 2.0F, 0.0F, 1.0F, 0.0F);
        GlStateManager.rotate(180.0F, 0.0F, 1.0F, 0.0F);
    }

    float getNaturalWindSwing(int part) {
        if (Atani.instance.moduleStorage.getT(Cape.class).windMode.is("Waves")) {
            long highlightedPart = (System.currentTimeMillis() / 3) % 360;
            float relativePart = (float) (part + 1) / partCount;
            return (float) (Math.sin(Math.toRadians((relativePart) * 360 - (highlightedPart))) * 3);
        }

        if (Atani.instance.moduleStorage.getT(Cape.class).windMode.is("Slight")) {
            return getWind(60);
        }

        return 0;
    }

    private static float easeOutSine(float x) {
        return (float) Math.sin((x * Math.PI) / 2f);
    }

    private static float getWind(double posY) {
        int scale = 1000 * 60 * 60;
        float x = (System.currentTimeMillis() % scale) / 10000f;
        float mod = MathHelper.clamp_float(1f / 200f * (float) posY, 0f, 1f);
        return MathHelper.clamp_float((float) (Math.sin(2 * x) + Math.sin(Math.PI * x)) * mod, 0, 2);
    }

    @Override
    public boolean shouldCombineTextures() {
        return false;
    }
}
