package tech.atani.client.util.game.player.waveycapes.math;

public class CloneableVector2f {
    public float x, y;

    public CloneableVector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public CloneableVector2f clone() {
        return new CloneableVector2f(x, y);
    }

    public void copy(CloneableVector2f vec) {
        this.x = vec.x;
        this.y = vec.y;
    }

    public CloneableVector2f add(CloneableVector2f vec) {
        this.x += vec.x;
        this.y += vec.y;
        return this;
    }

    public CloneableVector2f subtract(CloneableVector2f vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        return this;
    }

    public CloneableVector2f div(float amount) {
        this.x /= amount;
        this.y /= amount;
        return this;
    }

    public CloneableVector2f mul(float amount) {
        this.x *= amount;
        this.y *= amount;
        return this;
    }

    public CloneableVector2f normalize() {
        float f = (float) Math.sqrt(this.x * this.x + this.y * this.y);
        if (f < 1.0E-4F) {
            this.x = 0;
            this.y = 0;
        } else {
            this.x /= f;
            this.y /= f;
        }
        return this;
    }

    @Override
    public String toString() {
        return "Vector2 [x=" + x + ", y=" + y + "]";
    }

}