package tech.atani.client.util.game.player.waveycapes;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import tech.atani.client.Atani;
import tech.atani.client.module.impl.client.Cape;
import tech.atani.client.util.game.player.waveycapes.simulation.StickSimulation;

public interface Holder {
    StickSimulation getSimulation();

    default void simulate(EntityPlayer abstractClientPlayer) {
        StickSimulation simulation = getSimulation();

        if (simulation.points.isEmpty()) {
            return; // no cape, nothing to update
        }

        simulation.points.getFirst().prevPosition.copy(simulation.points.getFirst().position);
        double d = abstractClientPlayer.chasingPosX
                - abstractClientPlayer.posX;
        double m = abstractClientPlayer.chasingPosZ
                - abstractClientPlayer.posZ;
        float n = abstractClientPlayer.prevRenderYawOffset + abstractClientPlayer.renderYawOffset - abstractClientPlayer.prevRenderYawOffset;
        double o = Math.sin(n * 0.017453292F);
        double p = -Math.cos(n * 0.017453292F);
        float heightMul = Atani.instance.moduleStorage.getT(Cape.class).heightMultiplier.floatValue();
        // gives the cape a small swing when jumping/falling to not clip with itself/simulate some air getting under it
        double fallHack = MathHelper.clamp_double((simulation.points.getFirst().position.y - (abstractClientPlayer.posY * heightMul)), 0d, 1d);
        simulation.points.getFirst().position.x += (d * o + m * p) + fallHack;
        simulation.points.getFirst().position.y = (float) (abstractClientPlayer.posY * heightMul + (abstractClientPlayer.isSneaking() ? -4 : 0));
        simulation.simulate();
    }
}
