package tech.atani.client.util.game.player.point;

import net.minecraft.util.Vec3;
import tech.atani.client.util.Util;

import java.util.Objects;

public class PointKey extends Util {
    public int x, y, z;

    public PointKey(Vec3 point, double step) {
        this.x = (int) Math.round(point.xCoord / step);
        this.y = (int) Math.round(point.yCoord / step);
        this.z = (int) Math.round(point.zCoord / step);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PointKey other = (PointKey) o;
        return x == other.x && y == other.y && z == other.z;
    }

    @Override
    public int hashCode() {
        return Objects.hash(x, y, z);
    }
}