package tech.atani.client.util.game.player.hitzone;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import tech.atani.client.util.Util;
import tech.atani.client.util.game.player.RotationUtil;

import java.util.List;

public class HitZone extends Util {
    private int currentZoneIndex = 0;
    private float transitionProgress = 0;
    private static final float TRANSITION_SPEED = 0.04f;
    private long combatStartTick = -1;

    public record zone(AxisAlignedBB box, double weight) {}

    public List<zone> createDynamicHitZones(EntityLivingBase entity, AxisAlignedBB bb) {
        double height = bb.maxY - bb.minY;
        double centerX = (bb.minX + bb.maxX) / 2.0;

        float headArmor = getArmorValue(entity, 3);
        float torsoArmor = getArmorValue(entity, 2);
        float legArmor = getArmorValue(entity, 1);

        double headWeight = 0.35 - (headArmor / 20.0) * 0.15;
        double upperTorsoWeight = 0.25 + (torsoArmor / 20.0) * 0.05;
        double torsoWeight = 0.20 + (legArmor / 20.0) * 0.05;
        double leftArmWeight = 0.10;
        double rightArmWeight = 0.10;

        return List.of(
                new zone(new AxisAlignedBB(bb.minX, bb.maxY - height * 0.2, bb.minZ, bb.maxX, bb.maxY, bb.maxZ), headWeight),
                new zone(new AxisAlignedBB(bb.minX, bb.maxY - height * 0.4, bb.minZ, bb.maxX, bb.maxY - height * 0.2, bb.maxZ), upperTorsoWeight),
                new zone(new AxisAlignedBB(bb.minX, bb.maxY - height * 0.6, bb.minZ, bb.maxX, bb.maxY - height * 0.4, bb.maxZ), torsoWeight),
                new zone(new AxisAlignedBB(bb.minX, bb.maxY - height * 0.6, bb.minZ, centerX, bb.maxY - height * 0.2, bb.maxZ), leftArmWeight),
                new zone(new AxisAlignedBB(centerX, bb.maxY - height * 0.6, bb.minZ, bb.maxX, bb.maxY - height * 0.2, bb.maxZ), rightArmWeight)
        );
    }

    private float getArmorValue(EntityLivingBase entity, int slot) {
        ItemStack stack = entity.getCurrentArmor(slot);
        if (stack != null && stack.getItem() instanceof ItemArmor armor) {
            return armor.getArmorMaterial().getDamageReductionAmount(armor.armorType);
        }
        return 0;
    }

    public AxisAlignedBB updateTargetZone(List<zone> zones, EntityLivingBase entity, float healthFactor, double distance, Vec3 playerEyes) {
        if (combatStartTick == -1) {
            combatStartTick = mc.theWorld.getTotalWorldTime();
        }

        float velocityX = (float)(entity.posX - entity.lastTickPosX) * 20.0f;
        float velocityZ = (float)(entity.posZ - entity.lastTickPosZ) * 20.0f;
        float velocityGradientX = Math.abs(velocityX - RotationUtil.getLastVelocityX());
        float velocityGradientZ = Math.abs(velocityZ - RotationUtil.getLastVelocityZ());

        long combatDuration = mc.theWorld.getTotalWorldTime() - combatStartTick;
        float playerVelocity = (float)Math.sqrt(
                Math.pow(mc.thePlayer.posX - mc.thePlayer.lastTickPosX, 2) +
                        Math.pow(mc.thePlayer.posZ - mc.thePlayer.lastTickPosZ, 2)) * 20.0f;

        float yawDiff = Math.abs(MathHelper.wrapAngleTo180_float(entity.rotationYaw - mc.thePlayer.rotationYaw));
        float pitchDiff = Math.abs(mc.thePlayer.rotationPitch);

        int tickCycle = (int)(combatDuration % 45);
        float armorFactor = entity.getTotalArmorValue() / 20.0f;
        float engagementIntensity = (velocityGradientX + velocityGradientZ + playerVelocity) * 0.1f;

        transitionProgress += TRANSITION_SPEED * (0.7f + Math.min(engagementIntensity, 0.5f));
        if (transitionProgress >= 1.0f) {
            transitionProgress = 0;
            if (distance > 18.0 && velocityGradientX > 0.25f && armorFactor > 0.6f) {
                currentZoneIndex = (currentZoneIndex + 4) % zones.size();
            } else if (distance < 2.0 && tickCycle % 6 == 0 && playerVelocity > 0.4f) {
                currentZoneIndex = (currentZoneIndex + 3) % zones.size();
            } else if (yawDiff > 150.0f && velocityZ > 0.3f && RotationUtil.getMomentumFactor() > 0.8f) {
                currentZoneIndex = (currentZoneIndex + 2) % zones.size();
            } else if (combatDuration > 150 && pitchDiff < 20.0f) {
                currentZoneIndex = (currentZoneIndex + 1 + (tickCycle % 3)) % zones.size();
            } else {
                currentZoneIndex = (currentZoneIndex + 1) % zones.size();
            }
        }

        if (healthFactor < 0.1f) {
            currentZoneIndex = 0;
        } else if (healthFactor < 0.35f && tickCycle > 25 && armorFactor < 0.4f) {
            currentZoneIndex = (pitchDiff > 30.0f) ? 1 : 2;
        } else if (velocityGradientX > 0.35f && distance < 3.5 && RotationUtil.getMomentumFactor() > 0.6f) {
            currentZoneIndex = (velocityX > 0) ? 3 : 4;
        } else if (yawDiff < 15.0f && playerVelocity > 0.6f && tickCycle % 10 == 0) {
            currentZoneIndex = (combatDuration % 60 < 30) ? 2 : 1;
        } else if (combatDuration > 120 && velocityGradientZ > 0.25f && pitchDiff > 40.0f) {
            currentZoneIndex = (tickCycle % 4 < 2) ? 3 : 4;
        } else if (armorFactor > 0.7f && distance > 10.0 && engagementIntensity < 0.3f) {
            currentZoneIndex = 1;
        }

        return zones.get(currentZoneIndex).box();
    }

    public Vec3 predictEntityMotion(EntityLivingBase entity) {
        double accelerationX = (entity.posX - entity.lastTickPosX) - (entity.lastTickPosX - entity.prevPosX);
        double accelerationY = (entity.posY - entity.lastTickPosY) - (entity.lastTickPosY - entity.prevPosY);
        double accelerationZ = (entity.posZ - entity.lastTickPosZ) - (entity.lastTickPosZ - entity.prevPosZ);

        return new Vec3(
                (entity.posX - entity.lastTickPosX) * 1.5 + accelerationX * 0.5,
                (entity.posY - entity.lastTickPosY) * 1.5 + accelerationY * 0.5,
                (entity.posZ - entity.lastTickPosZ) * 1.5 + accelerationZ * 0.5
        );
    }

    public Vec3 adjustTargetPoint(Vec3 point, double height, float healthFactor, double distance, EntityLivingBase entity) {
        double heightAdjustment = height * 0.02 * (1 - healthFactor);
        double distanceAdjustment = Math.min(0.04, distance * 0.004);
        long tickOffset = mc.theWorld.getTotalWorldTime() % 30;
        float facingFactor = MathHelper.cos(entity.rotationYaw * 0.017453292f) * 0.01f;
        float velocityInfluence = (float)(entity.posY - entity.lastTickPosY) * 0.06f;
        float playerPitchInfluence = mc.thePlayer.rotationPitch * 0.0006f;

        return point.addVector(
                facingFactor,
                heightAdjustment + distanceAdjustment + tickOffset * 0.001 + velocityInfluence + playerPitchInfluence,
                facingFactor * 0.5
        );
    }
}