package tech.atani.client.util.game.player;

import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.util.MathHelper;
import tech.atani.client.util.Util;
import tech.atani.client.util.system.math.FastNoiseLite;

import java.security.SecureRandom;

@Getter
@Setter
@Builder
public class SmoothUtil extends Util {
    private float currentYaw;
    private float currentPitch;
    private float noiseOffset;
    private long lastTick;
    private FastNoiseLite noiseGen;
    private SecureRandom random;
    private int fractalOctaves;
    private float frequency;
    private float fractalGain;
    private float smoothSpeed;
    private float noiseStrength;

    public float[] smooth(float targetYaw, float targetPitch) {
        if (mc.thePlayer == null) {
            return new float[]{targetYaw, targetPitch};
        }

        if (noiseGen == null) {
            noiseGen = new FastNoiseLite();
            noiseGen.SetNoiseType(FastNoiseLite.NoiseType.Perlin);
            noiseGen.SetFractalType(FastNoiseLite.FractalType.FBm);
        }

        if (random == null) {
            random = new SecureRandom();
        }

        noiseGen.SetFractalOctaves(fractalOctaves);
        noiseGen.SetFrequency(frequency);
        noiseGen.SetFractalGain(fractalGain);

        if (lastTick == 0) {
            currentYaw = wrapDegrees(targetYaw);
            currentPitch = targetPitch;
            lastTick = System.currentTimeMillis();
        }

        long currentTick = System.currentTimeMillis();
        float tickDelta = Math.min((currentTick - lastTick) / 50f, 2.0f);
        lastTick = currentTick;

        noiseOffset += tickDelta * (0.15f + random.nextFloat() * 0.05f);

        float wrappedTargetYaw = wrapDegrees(targetYaw);
        float yawDiff = wrapDegrees(wrappedTargetYaw - currentYaw);
        float pitchDiff = targetPitch - currentPitch;

        float yawNoise = noiseGen.GetNoise(noiseOffset, 0) * noiseStrength * (0.8f + random.nextFloat() * 0.4f);
        float pitchNoise = noiseGen.GetNoise(noiseOffset, 1337) * noiseStrength * (0.8f + random.nextFloat() * 0.4f);

        float variedSmoothSpeed = smoothSpeed * (0.95f + random.nextFloat() * 0.1f);
        float smoothFactor = MathHelper.clamp_float(variedSmoothSpeed * tickDelta * 2.0f, 0, 1);

        if (random.nextFloat() < 0.05f) {
            smoothFactor *= 0.6f;
        }

        float smoothedYawDiff = yawDiff * smoothFactor + yawNoise * (1 - smoothFactor);
        float smoothedPitchDiff = pitchDiff * smoothFactor + pitchNoise * (1 - smoothFactor);

        currentYaw = wrapDegrees(currentYaw + smoothedYawDiff);
        currentPitch = MathHelper.clamp_float(currentPitch + smoothedPitchDiff, -90f, 90f);

        float[] smoothedRotation = new float[]{currentYaw, currentPitch};
        return RotationUtil.sensitivity(smoothedRotation);
    }

    private static float wrapDegrees(float angle) {
        angle %= 360.0F;
        if (angle >= 180.0F) {
            angle -= 360.0F;
        }
        if (angle < -180.0F) {
            angle += 360.0F;
        }
        return angle;
    }

    public void reset(float yaw, float pitch) {
        currentYaw = wrapDegrees(yaw);
        currentPitch = pitch;
        noiseOffset = 0;
        lastTick = 0;
    }
}