package tech.atani.client.util.game.player;

import lombok.Getter;
import lombok.Setter;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.*;
import org.apache.commons.math3.util.FastMath;
import org.lwjgl.util.vector.Vector2f;
import tech.atani.client.util.Util;
import tech.atani.client.util.game.entity.RayCastUtil;
import tech.atani.client.util.game.player.hitzone.HitZone;

import java.security.SecureRandom;
import java.util.List;

import static tech.atani.client.util.game.player.point.PointFinder.*;

@SuppressWarnings("unused")
public class RotationUtil extends Util {
    @Getter @Setter
    private static float yaw, pitch;
    @Getter @Setter
    private static float lastYaw, lastPitch;

    @Getter @Setter
    private static float lastVelocityX = 0;
    @Getter @Setter
    private static float lastVelocityZ = 0;
    @Getter @Setter
    private static float momentumFactor = 0;

    private static final SecureRandom RANDOM = new SecureRandom();
    private static final HitZone hitZoneManager = new HitZone();

    public static float[] setRotation(EntityLivingBase entity, double stepSize, boolean closest) {
        if (entity == null || mc.thePlayer == null) {
            return null;
        }

        Vec3 playerEyes = new Vec3(
                mc.thePlayer.posX,
                mc.thePlayer.posY + mc.thePlayer.getEyeHeight(),
                mc.thePlayer.posZ
        );

        AxisAlignedBB bb = entity.getEntityBoundingBox();
        Vec3 entityMotion = hitZoneManager.predictEntityMotion(entity);
        Vec3 targetPoint;

        if (closest) {
            List<HitZone.zone> hitZones = hitZoneManager.createDynamicHitZones(entity, bb);
            float healthFactor = entity.getHealth() / entity.getMaxHealth();
            double distance = playerEyes.distanceTo(new Vec3((bb.minX + bb.maxX) / 2.0, bb.maxY - (bb.maxY - bb.minY) / 2, (bb.minZ + bb.maxZ) / 2.0));

            AxisAlignedBB targetBox = hitZoneManager.updateTargetZone(hitZones, entity, healthFactor, distance, playerEyes);
            targetPoint = findClosestVisiblePoint(playerEyes, targetBox, stepSize);

            if (targetPoint != null) {
                targetPoint = targetPoint.addVector(entityMotion.xCoord, entityMotion.yCoord, entityMotion.zCoord);
            }

            if (targetPoint == null) {
                targetPoint = findClosestVisiblePoint(playerEyes, hitZones.getFirst().box(), stepSize);
                if (targetPoint != null) {
                    targetPoint = targetPoint.addVector(entityMotion.xCoord, entityMotion.yCoord, entityMotion.zCoord);
                }
            }

            if (targetPoint == null) {
                return null;
            }

            targetPoint = hitZoneManager.adjustTargetPoint(targetPoint, bb.maxY - bb.minY, healthFactor, distance, entity);
        } else {
            targetPoint = findClosestVisiblePoint(playerEyes, bb, stepSize);
            if (targetPoint != null) {
                targetPoint = targetPoint.addVector(entityMotion.xCoord, entityMotion.yCoord, entityMotion.zCoord);
            } else {
                return null;
            }
        }

        float[] rotations = toRotation(playerEyes, targetPoint);

        lastVelocityX = (float) (entity.posX - entity.lastTickPosX) * 20.0f;
        lastVelocityZ = (float) (entity.posZ - entity.lastTickPosZ) * 20.0f;
        momentumFactor = Math.min(1.0f, momentumFactor + (Math.abs(lastVelocityX) + Math.abs(lastVelocityZ)) * 0.02f);

        return rotations;
    }

    public static float[] toRotation(Vec3 origin, Vec3 target) {
        double x = target.xCoord - origin.xCoord;
        double y = target.yCoord - origin.yCoord;
        double z = target.zCoord - origin.zCoord;

        double theta = Math.hypot(x, z);

        float yaw = (float) -Math.toDegrees(Math.atan2(x, z));
        float pitch = (float) Math.toDegrees(-Math.atan2(y, theta));

        return new float[]{MathHelper.wrapAngleTo180_float(yaw), MathHelper.clamp_float(pitch, -90, 90)};
    }

    public static float[] sensitivity(final float[] rotation) {
        final float[] previousRotation = new float[]{mc.thePlayer.prevRotationYaw, mc.thePlayer.prevRotationPitch};
        return sensitivity(rotation, previousRotation);
    }

    public static float[] sensitivity(final float[] rotation, final float[] previousRotation) {
        final float sensitivity = mc.gameSettings.mouseSensitivity;
        final float multiplier = sensitivity * 0.6f + 0.2f;
        final float deltaScale = 8.0f * 0.15f;
        final float step = multiplier * deltaScale;
        final float deltaYaw = rotation[0] - previousRotation[0];
        final float deltaPitch = rotation[1] - previousRotation[1];
        final float yaw = previousRotation[0] + (float) Math.round(deltaYaw / step) * step;
        final float pitch = previousRotation[1] + (float) Math.round(deltaPitch / step) * step;
        return new float[]{yaw, MathHelper.clamp_float(pitch, -90.0f, 90.0f)};
    }

    public static float[] getDirectionToBlock(double x, double y, double z, EnumFacing facing) {
        double offsetX = x + 0.5 + facing.getDirectionVec().getX() * 0.5;
        double offsetY = y + 0.5 + facing.getDirectionVec().getY() * 0.5;
        double offsetZ = z + 0.5 + facing.getDirectionVec().getZ() * 0.5;

        double xDiff = offsetX - mc.thePlayer.posX;
        double yDiff = offsetY - (mc.thePlayer.posY + mc.thePlayer.getEyeHeight());
        double zDiff = offsetZ - mc.thePlayer.posZ;

        double dist = Math.hypot(xDiff, zDiff);

        float yaw = (float) Math.toDegrees(Math.atan2(zDiff, xDiff)) - 90.0F;
        float pitch = (float) -Math.toDegrees(Math.atan2(yDiff, dist));

        return new float[]{MathHelper.wrapAngleTo180_float(yaw), MathHelper.clamp_float(pitch, -90.0F, 90.0F)};
    }

    public static float calculatePitch(BlockPos blockPos, EnumFacing facing, float currentYaw, float lastPitch, int maxPitch) {
        if (mc.thePlayer == null || mc.theWorld == null || blockPos == null || facing == null) {
            return lastPitch;
        }

        float idealPitch = getIdealPitch(blockPos, facing);

        if (idealPitch > maxPitch || idealPitch < 45) {
            return lastPitch;
        }

        MovingObjectPosition ray = RayCastUtil.rayCast(
                new Vector2f(currentYaw, idealPitch),
                mc.playerController.getBlockReachDistance(),
                1.0f,
                mc.thePlayer
        );

        if (ray != null && ray.getBlockPos() != null && ray.sideHit != null &&
                ray.getBlockPos().equalsBlockPos(blockPos) && ray.sideHit == facing) {
            return idealPitch;
        }

        return lastPitch;
    }

    private static float getIdealPitch(BlockPos blockPos, EnumFacing facing) {
        double playerX = mc.thePlayer.posX;
        double playerY = mc.thePlayer.posY + mc.thePlayer.getEyeHeight();
        double playerZ = mc.thePlayer.posZ;

        AxisAlignedBB bb = mc.theWorld.getBlockState(blockPos).getBlock().getCollisionBoundingBox(mc.theWorld, blockPos, mc.theWorld.getBlockState(blockPos));

        if (bb == null) {
            bb = new AxisAlignedBB(
                    blockPos.getX(), blockPos.getY(), blockPos.getZ(),
                    blockPos.getX() + 1, blockPos.getY() + 1, blockPos.getZ() + 1
            );
        }

        double baseX = blockPos.getX() + 0.5 + facing.getDirectionVec().getX() * 0.5;
        double baseY = blockPos.getY() + 0.5 + facing.getDirectionVec().getY() * 0.5;
        double baseZ = blockPos.getZ() + 0.5 + facing.getDirectionVec().getZ() * 0.5;

        baseX = Math.max(bb.minX, Math.min(baseX, bb.maxX));
        baseY = Math.max(bb.minY, Math.min(baseY, bb.maxY));
        baseZ = Math.max(bb.minZ, Math.min(baseZ, bb.maxZ));

        double deltaX = baseX - playerX;
        double deltaY = baseY - playerY;
        double deltaZ = baseZ - playerZ;

        double horizontalDist = FastMath.hypot(deltaX, deltaZ);

        return (float) -FastMath.toDegrees(FastMath.atan2(deltaY, horizontalDist));
    }
}