package tech.atani.client.util.game.player;

import net.minecraft.util.AxisAlignedBB;
import org.lwjgl.input.Keyboard;
import tech.atani.client.event.impl.MoveInputEvent;
import tech.atani.client.util.Util;
import tech.atani.client.util.client.interfaces.IMinecraft;

public class MovementUtil extends Util {

    public static void stop() {
        mc.thePlayer.motionX = mc.thePlayer.motionZ = 0;
    }

    public static double getDirectionKeybinds(float yaw) {
        float rotationYaw = yaw;
        if (!Keyboard.isKeyDown(mc.gameSettings.keyBindForward.getKeyCode()) && Keyboard.isKeyDown(mc.gameSettings.keyBindBack.getKeyCode())) {
            rotationYaw = yaw + 180.0F;
        }

        float forward = 1.0F;
        if (!Keyboard.isKeyDown(mc.gameSettings.keyBindForward.getKeyCode()) && Keyboard.isKeyDown(mc.gameSettings.keyBindBack.getKeyCode())) {
            forward = -0.5F;
        } else if (Keyboard.isKeyDown(mc.gameSettings.keyBindForward.getKeyCode()) && !Keyboard.isKeyDown(mc.gameSettings.keyBindBack.getKeyCode())) {
            forward = 0.5F;
        }

        if (Keyboard.isKeyDown(mc.gameSettings.keyBindLeft.getKeyCode()) && !Keyboard.isKeyDown(mc.gameSettings.keyBindRight.getKeyCode())) {
            rotationYaw -= 90.0F * forward;
        }

        if (!Keyboard.isKeyDown(mc.gameSettings.keyBindLeft.getKeyCode()) && Keyboard.isKeyDown(mc.gameSettings.keyBindRight.getKeyCode())) {
            rotationYaw += 90.0F * forward;
        }

        return Math.toRadians(rotationYaw);
    }

    public static boolean isMoving() {
        return mc.thePlayer.moveForward != 0 || mc.thePlayer.moveStrafing != 0;
    }

    public static void correctMovement(final MoveInputEvent event, final float yaw) {
        if (event.getForward() == 0 && event.getStrafe() == 0) {
            return;
        }

        float realYaw = mc.thePlayer.rotationYaw;

        float moveX = event.getStrafe() * (float) Math.cos(Math.toRadians(realYaw)) - event.getForward() * (float) Math.sin(Math.toRadians(realYaw));
        float moveZ = event.getForward() * (float) Math.cos(Math.toRadians(realYaw)) + event.getStrafe() * (float) Math.sin(Math.toRadians(realYaw));

        double[] bestMovement = null;

        for (int forward = -1; forward <= 1; forward++) {
            for (int strafe = -1; strafe <= 1; strafe++) {
                if (forward == 0 && strafe == 0) continue;

                float newMoveX = strafe * (float) Math.cos(Math.toRadians(yaw)) - forward * (float) Math.sin(Math.toRadians(yaw));
                float newMoveZ = forward * (float) Math.cos(Math.toRadians(yaw)) + strafe * (float) Math.sin(Math.toRadians(yaw));

                float deltaX = newMoveX - moveX;
                float deltaZ = newMoveZ - moveZ;

                double dist = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);

                if (bestMovement == null || bestMovement[0] > dist) {
                    bestMovement = new double[]{dist, forward, strafe};
                }
            }
        }

        event.setForward((float) Math.round(bestMovement[1]));
        event.setStrafe((float) Math.round(bestMovement[2]));
    }

    public static double getSpeed() {
        if (mc.thePlayer == null) {
            return 0.0;
        }

        double x = mc.thePlayer.motionX;
        double z = mc.thePlayer.motionZ;
        return Math.hypot(x, z);
    }

    public static void strafe() {
        strafe(getSpeed());
    }

    public static void strafe(double moveSpeed) {
        if (mc.thePlayer.movementInput.moveForward != 0.0) {
            mc.thePlayer.movementInput.moveForward = (mc.thePlayer.movementInput.moveForward > 0.0) ? 1.0f : -1.0f;
        }

        if (mc.thePlayer.movementInput.moveStrafe != 0.0) {
            mc.thePlayer.movementInput.moveStrafe = (mc.thePlayer.movementInput.moveStrafe > 0.0) ? 1.0f : -1.0f;
        }

        if (mc.thePlayer.movementInput.moveForward == 0.0 && mc.thePlayer.movementInput.moveStrafe == 0.0) {
            mc.thePlayer.motionX = 0.0;
            mc.thePlayer.motionZ = 0.0;
            return;
        }

        if (mc.thePlayer.movementInput.moveForward != 0.0 && mc.thePlayer.movementInput.moveStrafe != 0.0) {
            mc.thePlayer.movementInput.moveForward *= (float) Math.sin(Math.toRadians(36.67));
            mc.thePlayer.movementInput.moveStrafe *= (float) Math.cos(Math.toRadians(36.67));
        }

        double yawRadians = Math.toRadians(mc.thePlayer.rotationYaw);
        mc.thePlayer.motionX = mc.thePlayer.movementInput.moveForward * moveSpeed * -Math.sin(yawRadians) + mc.thePlayer.movementInput.moveStrafe * moveSpeed * Math.cos(yawRadians);
        mc.thePlayer.motionZ = mc.thePlayer.movementInput.moveForward * moveSpeed * Math.cos(yawRadians) - mc.thePlayer.movementInput.moveStrafe * moveSpeed * -Math.sin(yawRadians);
    }

    public static void setSpeed(double moveSpeed, float yaw, double strafe, double forward) {
        if (forward != 0.0D) {
            yaw += (strafe > 0.0D) ? (forward > 0.0D ? -45 : 45) : (strafe < 0.0D) ? (forward > 0.0D ? 45 : -45) : 0;
            strafe = 0.0D;
            forward = (forward > 0.0D) ? 1.0D : -1.0D;
        }

        if (strafe != 0.0D) {
            strafe = (strafe > 0.0D) ? 1.0D : -1.0D;
        }

        double radianYaw = Math.toRadians(yaw + 90.0F);
        double cosYaw = Math.cos(radianYaw);
        double sinYaw = Math.sin(radianYaw);

        mc.thePlayer.motionX = forward * moveSpeed * cosYaw + strafe * moveSpeed * sinYaw;
        mc.thePlayer.motionZ = forward * moveSpeed * sinYaw - strafe * moveSpeed * cosYaw;
    }

    public static void setSpeed(double moveSpeed) {
        setSpeed(moveSpeed, mc.thePlayer.rotationYaw, mc.thePlayer.movementInput.moveStrafe, mc.thePlayer.movementInput.moveForward);
    }

    public static boolean isOnEdge(double extrapolation) {
        if (mc.thePlayer == null || mc.theWorld == null) {
            return false;
        }

        AxisAlignedBB boundingBox = mc.thePlayer.getEntityBoundingBox();
        double offsetX = mc.thePlayer.motionX * extrapolation;
        double offsetY = -mc.thePlayer.stepHeight; // stepHeight is a float in 1.8.9
        double offsetZ = mc.thePlayer.motionZ * extrapolation;

        AxisAlignedBB offsetBox = boundingBox.offset(offsetX, offsetY, offsetZ);
        return mc.theWorld.checkBlockCollision(offsetBox);
    }
}
