package tech.atani.client.util.game.player;

import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.*;
import net.minecraft.util.DamageSource;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import tech.atani.client.util.Util;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class InventoryUtil extends Util {
    private static final Set<Object> INVALID_ITEMS = Set.of(
            Blocks.sand, Blocks.gravel, Blocks.dispenser, Blocks.command_block, Blocks.noteblock, Blocks.furnace, Blocks.crafting_table, Blocks.tnt,
            Blocks.dropper, Blocks.beacon, Blocks.soul_sand, Blocks.snow, Blocks.ice, Blocks.pumpkin,
            Blocks.air, Blocks.water, Blocks.lava, Blocks.flowing_water, Blocks.flowing_lava,
            Blocks.enchanting_table, Blocks.web, Blocks.carpet, Blocks.nether_brick_fence,
            Blocks.oak_fence, Blocks.acacia_fence, Blocks.birch_fence, Blocks.jungle_fence, Blocks.dark_oak_fence, Blocks.spruce_fence, Blocks.oak_fence_gate,
            Blocks.acacia_fence_gate, Blocks.birch_fence_gate, Blocks.jungle_fence_gate, Blocks.dark_oak_fence_gate, Blocks.spruce_fence_gate, Blocks.torch,
            Blocks.redstone_torch, Blocks.stone_slab, Blocks.stone_slab2, Blocks.wooden_slab, Blocks.snow_layer, Blocks.ladder, Blocks.sapling, Blocks.vine,
            Blocks.tallgrass, Blocks.waterlily, Blocks.deadbush, Blocks.redstone_wire, Blocks.chest, Blocks.ender_chest, Blocks.trapped_chest, Blocks.double_plant,
            Blocks.flower_pot, Blocks.red_flower, Blocks.yellow_flower, Blocks.skull, Blocks.farmland, Blocks.standing_sign, Blocks.wall_sign,
            Items.stick, Items.flint, Items.feather, Items.string, Items.bone, Items.rotten_flesh, Items.spider_eye, Items.poisonous_potato, Items.pumpkin_seeds,
            Items.melon_seeds, Items.wheat_seeds, Items.sugar, Items.paper, Items.leather, Items.clay_ball, Items.ghast_tear, Items.glass_bottle,
            Items.carrot, Items.potato, Items.golden_horse_armor, Items.iron_horse_armor, Items.diamond_horse_armor, Items.saddle, Items.wooden_hoe, Items.stone_hoe,
            Items.milk_bucket, Items.snowball, Items.egg
    );

    public static int findBlockSlot() {
        if (mc.thePlayer == null) return -1;

        OptionalInt slot = IntStream.range(0, 9)
                .filter(i -> {
                    ItemStack stack = mc.thePlayer.inventory.getStackInSlot(i);
                    return stack != null && stack.getItem() instanceof ItemBlock;
                })
                .findFirst();

        return slot.orElse(-1);
    }

    public static void setSlot(int slot) {
        if (mc.thePlayer == null || !isValidHotbarSlot(slot)) return;

        mc.thePlayer.inventory.currentItem = slot;
        mc.playerController.updateController();
    }

    public static int findBlockSlotInInventory() {
        if (mc.thePlayer == null) return -1;

        return IntStream.range(0, mc.thePlayer.inventory.mainInventory.length)
                .filter(i -> {
                    ItemStack stack = mc.thePlayer.inventory.getStackInSlot(i);
                    return stack != null && stack.getItem() instanceof ItemBlock;
                })
                .findFirst()
                .orElse(-1);
    }

    private static boolean isValidHotbarSlot(int slot) {
        return switch (slot) {
            case 0, 1, 2, 3, 4, 5, 6, 7, 8 -> true;
            default -> false;
        };
    }

    public static void stealSlot(int slot) {
        mc.playerController.windowClick(mc.thePlayer.openContainer.windowId, slot, 1, 1, mc.thePlayer);
    }

    public static void performClick(Container container, int slot, int button, int action, EntityPlayerSP player) {
        mc.playerController.windowClick(container.windowId, slot, button, action, player);
    }

    public static Slot getSlot(int index) {
        return mc.thePlayer.inventoryContainer.getSlot(index);
    }

    public static boolean isInventoryFull() {
        return IntStream.range(9, 45).noneMatch(i -> mc.thePlayer.inventoryContainer.getSlot(i).getStack() == null);
    }

    public static boolean isValidChest(GuiChest chestGui) {
        return chestGui.inventorySlots instanceof net.minecraft.inventory.ContainerChest containerChest &&
                Optional.ofNullable(containerChest.getLowerChestInventory().getName())
                        .map(name -> name.contains("Chest") || name.contains("Large Chest") || name.contains("Ender Chest"))
                        .orElse(false);
    }

    public static List<Integer> getNonEmptySlots(IInventory inventory) {
        return IntStream.range(0, inventory.getSizeInventory())
                .filter(i -> inventory.getStackInSlot(i) != null)
                .boxed()
                .collect(Collectors.toList());
    }

    public static int getBestAxe() {
        return getBestToolAgainstBlock(Blocks.planks, false);
    }

    public static int getBestPickaxe() {
        return getBestToolAgainstBlock(Blocks.stone, false);
    }

    public static int getBestShovel() {
        return getBestToolAgainstBlock(Blocks.dirt, false);
    }

    public static boolean isTrash(Item item) {
        return INVALID_ITEMS.contains(item.getClass());
    }

    public static boolean canPlaceOnBlock(Block block) {
        return !INVALID_ITEMS.contains(block);
    }

    public static int armorProt(ItemArmor armor, ItemStack item) {
        return armor.damageReduceAmount + EnchantmentHelper.getEnchantmentModifierDamage(new ItemStack[]{item}, DamageSource.generic);
    }

    public static int getBestSword(boolean hotbar) {
        return IntStream.range(0, hotbar ? 9 : 36)
                .mapToObj(i -> Pair.of(i, mc.thePlayer.inventory.getStackInSlot(i)))
                .filter(p -> p.getValue() != null && p.getValue().getItem() instanceof ItemSword sword)
                .map(p -> Triple.of(p.getKey(),
                        ((ItemSword) p.getValue().getItem()).getDamageVsEntity() +
                                EnchantmentHelper.getEnchantmentLevel(Enchantment.sharpness.effectId, p.getValue()) * 1.25f,
                        ((ItemSword) p.getValue().getItem()).getDamageVsEntity()))
                .reduce(Triple.of(-1, -1f, -1f),
                        (a, b) -> b.getMiddle() > a.getMiddle() ||
                                (Objects.equals(b.getMiddle(), a.getMiddle()) && b.getRight() < a.getRight()) ? b : a)
                .getLeft();
    }

    public static int getBestToolAgainstBlock(Block blockPos, boolean hotbar) {
        return IntStream.range(0, hotbar ? 9 : 36)
                .mapToObj(i -> Pair.of(i, mc.thePlayer.inventory.getStackInSlot(i)))
                .filter(p -> p.getValue() != null)
                .reduce(Pair.of(-1, 1f),
                        (a, b) -> b.getValue().getStrVsBlock(blockPos) > a.getValue() ?
                                Pair.of(b.getKey(), b.getValue().getStrVsBlock(blockPos)) : a,
                        (a, b) -> b.getValue() > a.getValue() ? b : a)
                .getKey();
    }

    public static List<Integer> getSortedByStackSize(List<Integer> list) {
        return list.stream()
                .sorted(Comparator.comparingInt(i -> mc.thePlayer.inventory.getStackInSlot(i) == null ? 0 : -mc.thePlayer.inventory.getStackInSlot(i).stackSize))
                .collect(Collectors.toList());
    }

    public static int getBestBlock() {
        return IntStream.range(0, 40)
                .mapToObj(i -> Pair.of(i, mc.thePlayer.inventory.getStackInSlot(i)))
                .filter(p -> p.getValue() != null && p.getValue().getItem() instanceof ItemBlock itemBlock && canPlaceOnBlock(itemBlock.getBlock()))
                .reduce(Pair.of(-1, -1),
                        (a, b) -> b.getValue().stackSize > a.getValue() ? Pair.of(b.getKey(), b.getValue().stackSize) : a,
                        (a, b) -> b.getValue() > a.getValue() ? b : a)
                .getKey();
    }

    public static int getBestArmor(int armorType) {
        return IntStream.range(0, 40)
                .mapToObj(i -> Pair.of(i, mc.thePlayer.inventory.getStackInSlot(i)))
                .filter(p -> p.getValue() != null && p.getValue().getItem() instanceof ItemArmor armor && armor.armorType == armorType)
                .reduce(Pair.of(-1, -1f),
                        (a, b) -> {
                            float prot = armorProt((ItemArmor) b.getValue().getItem(), b.getValue());
                            return prot > a.getValue() ? Pair.of(b.getKey(), prot) : a;
                        },
                        (a, b) -> b.getValue() > a.getValue() ? b : a)
                .getKey();
    }

    public static int getBestFood() {
        return IntStream.range(0, 40)
                .mapToObj(i -> Pair.of(i, mc.thePlayer.inventory.getStackInSlot(i)))
                .filter(p -> p.getValue() != null && p.getValue().getItem() instanceof ItemFood food)
                .reduce(Pair.of(-1, -1f),
                        (a, b) -> {
                            float val = ((ItemFood) b.getValue().getItem()).getSaturationModifier(b.getValue());
                            return val > a.getValue() ? Pair.of(b.getKey(), val) : a;
                        },
                        (a, b) -> b.getValue() > a.getValue() ? b : a)
                .getKey();
    }

    public static void switchToNextSlot() {
        int currentSlot = mc.thePlayer.inventory.currentItem;
        int nextSlot = -1;
        int currentBlockCount = getBlockCount(currentSlot);

        for (int i = 0; i < 9; i++) {
            if (i == currentSlot) continue;

            int slotBlockCount = getBlockCount(i);
            if ((slotBlockCount > currentSlot) || (currentBlockCount == 0 && slotBlockCount > 0)) {
                nextSlot = i;
                break;
            }
        }

        if (nextSlot != -1) {
            mc.thePlayer.inventory.currentItem = nextSlot;
        }
    }

    public static int getBlockCount(int slot) {
        ItemStack itemStack = mc.thePlayer.inventory.getStackInSlot(slot);

        if (itemStack != null && itemStack.getItem() instanceof ItemBlock) {
            return itemStack.stackSize;
        }

        return 0;
    }
}