package tech.atani.client.util.game.player;

import net.minecraft.client.settings.KeyBinding;
import tech.atani.client.util.Util;

public class ClickUtils extends Util {

    public static void action(final Button button, final Action action) {
        final KeyBinding bind = switch (button) {
            case LEFT -> mc.gameSettings.keyBindAttack;
            case RIGHT -> mc.gameSettings.keyBindUseItem;
        };

        final boolean pressed = (action == Action.PRESS);
        bind.setPressed(pressed);

        if (pressed) {
            KeyBinding.onTick(bind.getKeyCode());
        }
    }

    /**
     * Enum representing mouse buttons.
     */
    public enum Button {
        LEFT,
        RIGHT
    }

    /**
     * Enum representing mouse actions.
     */
    public enum Action {
        PRESS,
        RELEASE
    }
}