package tech.atani.client.util.game.entity;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import tech.atani.client.Atani;
import tech.atani.client.module.impl.combat.KillAura;
import tech.atani.client.util.Util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

@SuppressWarnings("unused")
public final class EntityUtil extends Util {
    private static final KillAura KILLAURA = Atani.instance.moduleStorage.getT(KillAura.class);
    public static volatile EntityLivingBase TARGET;
    public static volatile EntityLivingBase PREVIOUS_TARGET;
    public static volatile List<EntityLivingBase> TARGETS = new ArrayList<>();

    public static EntityLivingBase target(double range) {
        return Targets.get(range).stream().findFirst().orElse(null);
    }

    public static EntityLivingBase entity(boolean onlyKillAura) {
        return onlyKillAura ? target(KILLAURA.attackRange.getValue()) : TARGET;
    }

    public static final class Targets {
        public static List<EntityLivingBase> get(double range) {
            return filterRange(fetchTargets(), range);
        }

        public static List<EntityLivingBase> get(double range, boolean players, boolean invisibles, boolean animals, boolean mobs) {
            return filterRange(targets(players, invisibles, animals, mobs), range);
        }

        public static List<EntityLivingBase> get() {
            return fetchTargets();
        }

        public static List<EntityLivingBase> get(boolean players, boolean invisibles, boolean animals, boolean mobs) {
            return targets(players, invisibles, animals, mobs);
        }
    }

    public static Comparator<EntityLivingBase> sortComparator() {
        return switch (KILLAURA.mode.getValue()) {
            case "Health" -> Comparator.comparingDouble(EntityLivingBase::getHealth);
            case "Armor" -> Comparator.comparingInt(EntityLivingBase::getTotalArmorValue);
            case "Hurt-time" -> Comparator.comparingInt(EntityLivingBase::getHurtTime);
            default -> Comparator.comparingDouble(e -> mc.thePlayer.getDistanceToEyes(e));
        };
    }

    private static List<EntityLivingBase> targets(boolean players, boolean invisibles, boolean animals, boolean mobs) {
        if (Objects.isNull(mc.theWorld)) {
            return new ArrayList<>();
        }

        // shit instaceof //TODO rework this
        Predicate<Object> filter = e -> e instanceof EntityLivingBase elb
                && elb != mc.getRenderViewEntity()
                && (!(elb instanceof EntityPlayer) || players)
                && (!(elb instanceof IMob || elb instanceof EntitySlime) || mobs)
                && (!(elb instanceof EntityAnimal || elb instanceof EntityAmbientCreature || elb instanceof EntityWaterMob || elb instanceof INpc) || animals)
                && (!elb.isInvisible() || invisibles)
                && !(elb instanceof EntityArmorStand);

        return mc.theWorld.loadedEntityList.stream()
                .filter(filter)
                .map(e -> (EntityLivingBase) e)
                .collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    private static List<EntityLivingBase> fetchTargets() {
        return targets(
                KILLAURA.entities.isEnabled("Players"),
                KILLAURA.entities.isEnabled("Invisibles"),
                KILLAURA.entities.isEnabled("Animals"),
                KILLAURA.entities.isEnabled("Monsters")
        );
    }

    private static List<EntityLivingBase> filterRange(List<EntityLivingBase> entities, double range) {
        return entities.stream()
                .filter(e -> mc.thePlayer.getDistanceToEyes(e) <= range)
                .collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public static void setTarget(EntityLivingBase target) {
        PREVIOUS_TARGET = TARGET;
        TARGET = target;
    }

    public static void setTargets(List<EntityLivingBase> targets) {
        TARGETS = new ArrayList<>(targets);
    }

    public static EntityLivingBase getTarget() {
        return TARGET;
    }

    public static EntityLivingBase getPreviousTarget() {
        return PREVIOUS_TARGET;
    }

    public static List<EntityLivingBase> getTargets() {
        return TARGETS;
    }

    private EntityUtil() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }
}