package tech.atani.client.util.client.language;

import tech.atani.client.Atani;
import tech.atani.client.storage.impl.TranslationStorage;

import java.util.Locale;
import java.util.Set;

public class TranslationUtil {
    private static final TranslationStorage translationStorage;

    static {
        translationStorage = Atani.instance.translationStorage;
    }

    public static String getTranslation(String key) {
        return translationStorage.getTranslation(key);
    }

    public static String getTranslation(String key, Language language) {
        return translationStorage.getTranslation(key, language);
    }

    public static Language getCountryFromLocale() {
        String countryCode = Locale.getDefault().getCountry();

        switch (countryCode) {
            case "LV" -> {
                return Language.LATVIAN;
            }
            case "DE" -> {
                return Language.GERMAN;
            }
            case "FI" -> {
                return Language.FINNISH;
            }
            default -> {
                return Language.ENGLISH;
            }
        }
    }

    public static String getContinent() {
        String countryCode = Locale.getDefault().getCountry();

        Set<String> europe = Set.of("FI", "LV", "FR", "DE", "GB", "ES", "IT", "SE", "PL", "NL", "BE", "NO", "DK", "EE", "LT");
        Set<String> asia = Set.of("JP", "CN", "IN", "KR", "TH", "VN", "PH", "ID", "MY", "SG");
        Set<String> northAmerica = Set.of("US", "CA", "MX");
        Set<String> southAmerica = Set.of("BR", "AR", "CO", "CL", "PE", "VE");
        Set<String> africa = Set.of("ZA", "NG", "EG", "KE", "GH", "MA");
        Set<String> oceania = Set.of("AU", "NZ", "FJ");

        if (europe.contains(countryCode)) return "Europe";
        if (asia.contains(countryCode)) return "Asia";
        if (northAmerica.contains(countryCode)) return "North America";
        if (southAmerica.contains(countryCode)) return "South America";
        if (africa.contains(countryCode)) return "Africa";
        if (oceania.contains(countryCode)) return "Oceania";

        return "Unknown Continent";
    }
}