package tech.atani.client.util.client.language;

import java.util.HashMap;

public enum Language {
    ENGLISH("English", "translations/english.lang"),
    LATVIAN("Latviešu", "translations/latvian.lang"),
    GERMAN("Deutsch", "translations/german.lang"),
    FINNISH("Suomi", "translations/finnish.lang");

    public final String name, file;
    public final HashMap<String, String> translations = new HashMap<>();

    Language(String name, String file) {
        this.name = name;
        this.file = file;
    }

    public static Language getByName(String name) {
        for (Language lang : values()) {
            if (lang.name.equals(name)) {
                return lang;
            }
        }
        return ENGLISH;
    }
}