package tech.atani.client.util.client.interfaces;

import net.minecraft.client.Minecraft;
import net.minecraft.network.Packet;
import net.minecraft.util.ChatComponentText;

public interface IMinecraft {
    Minecraft mc = Minecraft.getMinecraft();

    default void sendPacket(Packet<?> packet) {
        mc.getNetHandler().addToSendQueue(packet);
    }

    default void sendPacketNoEvent(Packet<?> packet) {
        mc.getNetHandler().sendPacketNoEvent(packet);
    }

    default boolean nullCheck() {
        return mc.thePlayer != null && mc.theWorld != null;
    }

    default boolean nullEqual() {
        return mc.thePlayer == null && mc.theWorld == null;
    }

    default int fps() {
        return Minecraft.getDebugFPS();
    }

    default void info(String message, boolean prefix) {
        mc.thePlayer.addChatMessage(new ChatComponentText((prefix ? IClient.CHAT + "§r" : "") + message));
    }

    default void info(String message) {
        info(message, true);
    }

    static void chat(String message, boolean prefix) {
        mc.thePlayer.addChatMessage(new ChatComponentText((prefix ? IClient.CHAT + "§r" : "") + message));
    }

    static void chat(String message) {
        chat(message, true);
    }
}
